/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.sample.join;

import org.sql.column.JoinColumn;
import org.sql.comparison.Comparisons;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.JoinSql;
import org.sql.generator.Sql;
import org.sql.sample.AbstractSample;
import org.sql.table.SimpleTable;
import org.sql.type.Order;
import org.sql.util.GeneratorUtil;


/**
 * \SQL쐬NX
 * 
 * @author S.Nagashiba
 */
public class JoinSample extends AbstractSample {

	/**
     * SQL쐬
     * @return SQL
     * @throws GeneratorException SQLO
	 */
	protected Sql createSql() throws GeneratorException {
        //Jݒ
        JoinColumn join = new JoinColumn();
        join.append("TABLE1", "COLUMN1", "HOGE");
        join.append("TABLE2", "COLUMN2", "HOGEHOGE");

        //\
        SimpleTable table = new SimpleTable(new String[]{"TABLE1", "TABLE2"});

        //
        Condition condition = new Condition();
        condition.and(Comparisons.eq("TABLE1.COLUMN1", GeneratorUtil.formatExclusion("TABLE2.COLUMN1")));
        condition.and(Comparisons.eq("TABLE1.COLUMN1", new Integer(0)));
        
        //я
        Order[] order = new Order[2];
        order[0] = Order.asc("TABLE1.COLUMN1");
        order[1] = Order.asc("TABLE2.COLUMN2");
        
        //SQL
        JoinSql sql = new JoinSql();
        sql.addColumn(join);
        sql.addFrom(table);
        sql.setCondition(condition);
        sql.addOrder(order);
        
        return sql;
    }
}
