/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.type;


/**
 * ǗNX.
 *
 * @author S.Nagashiba
 */
public final class Format implements Types {

    /**  */
	private int formatMode;

	/** [h - N */
	private static final int ORA_YMD = 0;
	/** [h - b */
	private static final int ORA_HMS = 1;
	/** [h - Nb */
	private static final int ORA_YMD_HMS = 2;

	/** t - N */
	public static final Format YMD = new Format(ORA_YMD);
	/** t - b */
	public static final Format HMS = new Format(ORA_HMS);
	/** t - Nb */
	public static final Format YMD_HMS = new Format(ORA_YMD_HMS);

	
	/**
	 * RXgN^
	 * @param formatMode [h
	 */
	private Format(int formatMode) {
		this.formatMode = formatMode;
	}
	
	/**
	 * 擾
	 * @return 
	 */
	public String toTypeString() {
		String ret = null;
		switch (this.formatMode) {
			case ORA_YMD: ret = "YYYY/MM/DD"; break;
			case ORA_YMD_HMS: ret = "YYYY/MM/DD HH24:MI:SS"; break;
		}
		return ret;
	}
}