/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.sample;

import org.sql.column.RegistColumn;
import org.sql.comparison.Comparisons;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.Sql;
import org.sql.generator.UpdateSql;


/**
 * XVSQL쐬NX
 * 
 * @author S.Nagashiba
 */
public class UpdateSample extends AbstractSample {

    /**
     * SQL쐬
     * @return SQL
     * @throws GeneratorException SQLO
     */
    public Sql createSql() throws GeneratorException {
    	RegistColumn column = new RegistColumn();
        column.append("A", "");
        column.append("B", "");
        column.append("C", "");
        column.append("D", "{EMPTY_BLOB()}");
        
        Condition condition = new Condition();
        condition.and(Comparisons.eq("A", ""));
        
        UpdateSql sql = new UpdateSql("TABLE1");
        sql.setColumn(column);
        sql.setCondition(condition);
        
        return sql;
    }
}
