/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.sample;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

import org.sql.column.SelectColumn;
import org.sql.comparison.Comparisons;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.SelectSql;
import org.sql.generator.Sql;
import org.sql.type.Function;


/**
 * ֐gpSQL쐬NX
 * 
 * @author S.Nagashiba
 */
public class FunctionSample extends AbstractSample {

    /**
     * SQL쐬
     * @return SQL
     * @throws GeneratorException SQLO
     */
    public Sql createSql() throws GeneratorException {
        SelectColumn column = new SelectColumn();
        
        //NVL
        column.append(Function.nvl("COLUMN1", new Integer(-1)), "CLM1");
        
        //NVL2
        column.append(Function.nvl2("COLUMN2", new Integer(0), new Integer(-1)), "CLM2");

        //DECODE
        Map decoMap = new LinkedHashMap();
        decoMap.put("A", "AA");
        decoMap.put("B", "BB");
        column.append(Function.decode("COLUMN3", decoMap, "DEF"), "CLM3");

        //TRUNC
        column.append(Function.trunc("{COLUMN5}", 2), "CLM5");
        
        Condition condition = new Condition();
        condition.and(Comparisons.eq("COLUMN4", new Date()));
        
        SelectSql sql = new SelectSql("DUAL", column);
        sql.setCondition(condition);
        
        return sql;
    }
}
