/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.sample;

import org.sql.comparison.Comparisons;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.DeleteSql;
import org.sql.generator.Sql;


/**
 * 폜SQL쐬NX
 * 
 * @author S.Nagashiba
 */
public class DeleteSample extends AbstractSample {

    /**
     * SQL쐬
     * @return SQL
     * @throws GeneratorException SQLO
     */
    public Sql createSql() throws GeneratorException {
        DeleteSql sql = new DeleteSql("TABLE1");
        
        Condition condition = new Condition();
        condition.and(Comparisons.eq("A", ""));
        sql.setCondition(condition);
        
        return sql;
    }
}
