/*
 * Decompiled with CFR 0.152.
 */
package org.sql.message;

import java.util.ResourceBundle;

public final class Message {
    private static final String PROPERTIES_DIR = "org.sql.properties.Messages";
    private String errorCode = null;
    private String errorMessage = null;

    private Message() {
    }

    private Message(String errorCode) {
        this.errorCode = errorCode;
        ResourceBundle bundle = ResourceBundle.getBundle(PROPERTIES_DIR);
        this.errorMessage = bundle.getString(this.errorCode);
    }

    private Message(String errorCode, Object object) {
        this(errorCode, new Object[]{object});
    }

    private Message(String errorCode, Object[] objects) {
        this(errorCode);
        StringBuffer message = new StringBuffer(this.errorMessage);
        message.append("[");
        for (int i = 0; i < objects.length; ++i) {
            if (i > 0) {
                message.append(", ");
            }
            message.append(objects[i]);
        }
        message.append("]");
        this.errorMessage = message.toString();
    }

    public String getMessage() {
        return this.errorCode + "\uff1a" + this.errorMessage;
    }

    public static Message getInstance(String errorCode) {
        return new Message(errorCode);
    }

    public static Message getInstance(String errorCode, Object object) {
        return new Message(errorCode, object);
    }

    public static Message getInstance(String errorCode, Object[] objects) {
        return new Message(errorCode, objects);
    }
}

