/*
 * Decompiled with CFR 0.152.
 */
package org.sql.comparison;

import java.util.Date;
import org.sql.comparison.Comparison;
import org.sql.exception.ComparisonException;
import org.sql.exception.FormatException;
import org.sql.item.DefaultItem;
import org.sql.message.Message;
import org.sql.type.Format;
import org.sql.type.Function;
import org.sql.util.GeneratorUtil;

public abstract class AbstractComparison
implements Comparison {
    private static String ORA_YMD = Format.YMD.toTypeString();
    private static String ORA_HMS = Format.HMS.toTypeString();
    private static String ORA_YMD_HMS = Format.YMD_HMS.toTypeString();
    private static String JAVA_YMD = "yyyy/MM/dd";
    private static String JAVA_HMS = "HH:mm:ss";
    private static String JAVA_YMD_HMS = "yyyy/MM/dd HH:mm:ss";
    private DefaultItem comparison = new DefaultItem();
    private Throwable exception = null;

    protected AbstractComparison() {
    }

    protected void setComparison(DefaultItem comparison) {
        this.comparison = comparison;
    }

    public String toComparisonString() throws ComparisonException {
        if (this.exception != null) {
            throw new ComparisonException(this.exception);
        }
        return this.createComparison(this.comparison);
    }

    protected final String toDate(Date value, Format format) throws FormatException {
        String todate = null;
        String toformat = format.toTypeString();
        if (toformat.equals(ORA_YMD)) {
            todate = GeneratorUtil.dateToStr(value, JAVA_YMD);
        } else if (toformat.equals(ORA_HMS)) {
            todate = GeneratorUtil.dateToStr(value, JAVA_HMS);
        } else if (toformat.equals(ORA_YMD_HMS)) {
            todate = GeneratorUtil.dateToStr(value, JAVA_YMD_HMS);
        } else {
            throw new FormatException(Message.getInstance("SQL-002"));
        }
        return Function.toDate(todate, toformat).toTypeString();
    }

    public void clear() {
        this.comparison = null;
    }

    protected void setException(Throwable exception) {
        this.exception = exception;
    }

    public Throwable getException() {
        return this.exception;
    }

    protected abstract String createComparison(DefaultItem var1) throws ComparisonException;
}

