/*
 * Decompiled with CFR 0.152.
 */
package org.sql.column;

import java.util.LinkedHashMap;
import java.util.Map;
import org.sql.column.AbstractColumn;
import org.sql.exception.GeneratorException;
import org.sql.generator.SelectSql;
import org.sql.type.Types;

public class SelectColumn
extends AbstractColumn {
    private Map map = new LinkedHashMap();

    public SelectColumn() {
    }

    public SelectColumn(String column) {
        this.append(column);
    }

    public SelectColumn(String[] columns) {
        this.append(columns);
    }

    public void append(Types arg, String as) {
        super.append(arg.toTypeString() + " AS " + as);
    }

    public void append(String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            super.append(columns[i]);
        }
    }

    public void append(Number column, String as) {
        super.append(column.toString() + " AS " + as);
    }

    public void append(String column, String as) {
        super.append(column + " AS " + as);
    }

    public void append(String[] columns, String[] as) {
        for (int i = 0; i < columns.length; ++i) {
            this.append(columns[i], as[i]);
        }
    }

    public void append(Map map) {
        Object[] key = map.keySet().toArray();
        for (int i = 0; i < key.length; ++i) {
            this.append(key[i].toString(), map.get(key[i]).toString());
        }
    }

    public void append(SelectSql arg, String as) throws GeneratorException {
        super.append("(" + arg.getSql() + ") AS " + as);
        this.map.put(arg.getSql(), arg.getParameter());
    }

    public String toColumnString() {
        if (!super.isColumn()) {
            super.append("*");
        }
        return super.toColumnString();
    }

    public Map getMap() {
        return this.map;
    }
}

