/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.type;

/**
 * NULLǗNX.
 *
 * @author S.Nagashiba
 */
public final class Null implements Types {

    /** NULL */
	private int nullMode;

	/** NULL[h - NULL */
	private static final int NULL_MODE = 0;
	/** NULL[h - NOT NULL */
	private static final int NOT_NULL_MODE = 1;
	
	/** NULL[h - NULL */
	public static final Null NULL = new Null(NULL_MODE);
	/** NULL[h - NOT NULL */
	public static final Null NOT_NULL = new Null(NOT_NULL_MODE);
	
	/**
	 * RXgN^
	 * @param joinMode NULL[h
	 */
	private Null(int joinMode) {
		this.nullMode = joinMode;
	}
	
	/**
	 * NULL擾
	 * @return NULL
	 */
	public String toTypeString() {
		String ret = null;
		switch (this.nullMode) {
			case NULL_MODE: ret = "NULL"; break;
			case NOT_NULL_MODE: ret = "NOT NULL"; break;
		}
		return ret;
	}
}
