/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.type;

import java.util.Map;

import org.sql.util.GeneratorUtil;


/**
 * ֐ǗNX.
 *
 * @author S.Nagashiba
 */
public final class Function implements Types {

    /** ֐ */
    private String function;
    /** J */
	private String column;
	
    /**
     * RXgN^
     * @param function ֐
     * @param column J
     */
	private Function(String function, String column) {
        this.function = function;
		this.column = column;
    }
    
	/**
	 * ʕ擾
	 * @return ʕ
	 */
	public String toTypeString() {
		StringBuffer str = new StringBuffer();
		str.append(this.function);
		str.append("(");
		str.append(this.column);
		str.append(")");
		return str.toString();
	}
    
    /**
     * a߂֐IuWFNg擾
     * @param column J
     * @return ֐IuWFNg
     */
    public static Function sum(String column) {
        return new Function("SUM", column);
    }
    
    /**
     * ől߂֐IuWFNg擾
     * @param column J
     * @return ֐IuWFNg
     */
    public static Function max(String column) {
        return new Function("MAX", column);
    }
    
    /**
     * ŏl߂֐IuWFNg擾
     * @param column J
     * @return ֐IuWFNg
     */
    public static Function min(String column) {
        return new Function("MIN", column);
    }
    
    /**
     * ϒl߂֐IuWFNg擾
     * @param column J
     * @return ֐IuWFNg
     */
    public static Function avg(String column) {
        return new Function("AVG", column);
    }
    
    /**
     * ߂֐IuWFNg擾
     * @param column J
     * @return ֐IuWFNg
     */
    public static Function count(String column) {
        return new Function("COUNT", column);
    }
    
	/**
	 * ^ꂽ]w肳ꂽlԋp֐IuWFNg擾
	 * @param column ]J
	 * @param map    ]}bv
	 * @param def    ftHg̕ԋpl
	 * @return ֐IuWFNg
	 */
	public static Function decode(String column, Map map, Object def) {
	    StringBuffer str = new StringBuffer(column);
        
        Object[] key = map.keySet().toArray();
        for (int i = 0; i < key.length; i++) {
            str.append("," + GeneratorUtil.toQuoteString(key[i]));
            str.append("," + GeneratorUtil.toQuoteString(map.get(key[i])));
        }
        
        str.append(", ");
        str.append(GeneratorUtil.toQuoteString(def));
        
	    return new Function("DECODE", str.toString());
	}
	
	/**
	 * NULL]sK؂Ȓlԋp֐IuWFNg擾
	 * @param column ]J
	 * @param def    ftHg̕ԋpl
	 * @return ֐IuWFNg
	 */
	public static Function nvl(String column, Object def) {
	    return createFunction("NVL", new Object[]{"{" + column + "}", def});
	}
	
	/**
	 * NULL]sK؂Ȓlԋp֐IuWFNg擾
	 * @param column  ]J
	 * @param result1 ]ʂNULL̏ꍇɕԋpl
	 * @param result2 ]ʂNULLłȂꍇɕԋpl
	 * @return ֐IuWFNg
	 */
	public static Function nvl2(String column, Object result1, Object result2) {
	    return createFunction("NVL2", new Object[]{"{" + column + "}", result1, result2});
	}
	
	/**
	 * Βlԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @return ֐IuWFNg
	 */
	public static Function abs(Object column) {
	    return createFunction("ABS", column);
	}
	
	/**
	 * ľܓlԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @return ֐IuWFNg
	 */
	public static Function round(Object column) {
	    return createFunction("ROUND", column);
	}

	/**
	 * ľܓlԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param digit  w茅
	 * @return ֐IuWFNg
	 */
	public static Function round(Object column, int digit) {
	    return createFunction("ROUND", new Object[]{column, new Integer(digit)});
	}

	/**
	 * ؂̂Ălԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @return ֐IuWFNg
	 */
	public static Function trunc(Object column) {
	    return createFunction("TRUNC", column);
	}

	/**
	 * ؂̂Ălԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param digit  w茅
	 * @return ֐IuWFNg
	 */
	public static Function trunc(Object column, int digit) {
	    return createFunction("TRUNC", new Object[]{column, new Integer(digit)});
	}

	/**
	 * Zʂ̗]ԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param num    鐔
	 * @return ֐IuWFNg
	 */
	public static Function mod(Object column, int num) {
	    return createFunction("MOD", new Object[]{column, new Integer(num)});
	}
	
	/**
	 * E󔒏lԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @return ֐IuWFNg
	 */
	public static Function trim(String column) {
	    return createFunction("TRIM", column);
	}
	
	/**
	 * 󔒏lԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @return ֐IuWFNg
	 */
	public static Function ltrim(String column) {
	    return createFunction("LTRIM", column);
	}
	
	/**
	 * E󔒏lԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @return ֐IuWFNg
	 */
	public static Function rtrim(String column) {
	    return createFunction("RTRIM", column);
	}
	
	/** 
	 * tϊlԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param format 
	 * @return ֐IuWFNg
	 */
	public static Function toDate(String column, String format) {
	    return createFunction("TO_DATE", new Object[]{column, format});
	}
	
	/** 
	 * ϊlԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param format 
	 * @return ֐IuWFNg
	 */
	public static Function toChar(Object column, String format) {
	    return createFunction("TO_CHAR", new Object[]{column, format});
	}
	
	/** 
	 * lϊlԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param format 
	 * @return ֐IuWFNg
	 */
	public static Function toNumber(String column, String format) {
	    return createFunction("TO_NUMBER", new Object[]{column, format});
	}
	
	/**
	 * 啶ɕϊlԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @return ֐IuWFNg
	 */
	public static Function upper(String column) {
	    return createFunction("UPPER", column);
	}
	
	/**
	 * ɕϊlԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @return ֐IuWFNg
	 */
	public static Function lower(String column) {
	    return createFunction("LOWER", column);
	}
	
	/**
	 * P̐擪啶Acɕϊlԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @return ֐IuWFNg
	 */
	public static Function initcap(String column) {
	    return createFunction("INITCAP", column);
	}
	
	/**
	 * f[^Alԋp֐IuWFNg擾
	 * @param arg0 AJl1iJ̏ꍇ{}ň͂ށj
	 * @param arg1 AJl2iJ̏ꍇ{}ň͂ށj
	 * @return ֐IuWFNg
	 */
	public static Function concat(String arg0, String arg1) {
	    return createFunction("CONCAT", new Object[]{arg0, arg1});
	}
	
	/**
	 * f[^؂olԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param arg0 ؂oJnʒu
	 * @param arg1 ؂o
	 * @return ֐IuWFNg
	 */
	public static Function substr(String column, int arg0, int arg1) {
	    return createFunction("SUBSTR", new Object[]{column, new Integer(arg0), new Integer(arg1)});
	}
	
	/**
	 * f[^̕ԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @return ֐IuWFNg
	 */
	public static Function length(String column) {
	    return createFunction("LENGTH", column);
	}

	/**
	 * ʒuԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param arg 
	 * @return ֐IuWFNg
	 */
	public static Function instr(String column, String arg) {
	    return createFunction("INSTR", new Object[]{column, arg});
	}

	/**
	 * ʒuԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param arg0 
	 * @param arg1 Jnʒu
	 * @return ֐IuWFNg
	 */
	public static Function instr(String column, String arg0, int arg1) {
	    return createFunction("INSTR", new Object[]{column, arg0, new Integer(arg1)});
	}

	/**
	 * ʒuԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param arg0 
	 * @param arg1 Jnʒu
	 * @param arg2 o
	 * @return ֐IuWFNg
	 */
	public static Function instr(String column, String arg0, int arg1, int arg2) {
	    return createFunction("INSTR", new Object[]{column, arg0, new Integer(arg1), new Integer(arg2)});
	}

	/**
	 * f[^ɂlԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param arg w蕶
	 * @return ֐IuWFNg
	 */
	public static Function lpad(String column, int arg) {
	    return createFunction("LPAD", new Object[]{column, new Integer(arg), " "});
	}

	/**
	 * f[^ɂlԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param arg0 w蕶
	 * @param arg1 ̍ۂɖߍޕ
	 * @return ֐IuWFNg
	 */
	public static Function lpad(String column, int arg0, String arg1) {
	    return createFunction("LPAD", new Object[]{column, new Integer(arg0), arg1});
	}
	
	/**
	 * f[^Eɂlԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param arg w蕶
	 * @return ֐IuWFNg
	 */
	public static Function rpad(String column, int arg) {
	    return createFunction("RPAD", new Object[]{column, new Integer(arg), " "});
	}

	/**
	 * f[^Eɂlԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param arg0 w蕶
	 * @param arg1 E̍ۂɖߍޕ
	 * @return ֐IuWFNg
	 */
	public static Function rpad(String column, int arg0, String arg1) {
	    return createFunction("RPAD", new Object[]{column, new Integer(arg0), arg1});
	}
	
	/**
	 * f[^̒ulԋp֐IuWFNg擾
	 * @param column JliJ̏ꍇ{}ň͂ށj
	 * @param arg0 
	 * @param arg1 u
	 * @return ֐IuWFNg
	 */
	public static Function replace(String column, String arg0, String arg1) {
	    return createFunction("REPLACE", new Object[]{column, arg0, arg1});
	}

	/**
	 * ֐IuWFNg쐬
	 * @param function ֐
	 * @param arg 
	 * @return ֐IuWFNg
	 */
	public static Function createFunction(String function, Object arg) {
	    return createFunction(function, new Object[]{arg});
	}
	
	/**
	 * ֐IuWFNg쐬
	 * @param function ֐
	 * @param args 
	 * @return ֐IuWFNg
	 */
	public static Function createFunction(String function, Object[] args) {
	    StringBuffer str = new StringBuffer();
	    for (int i = 0; i < args.length; i++) {
	        if (str.toString().length() > 0) {
	            str.append(", ");
	        }
	        str.append(GeneratorUtil.toExclusionString(args[i]));
	    }
	    return new Function(function, str.toString());
	}
}
