/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import org.sql.exception.ComparisonException;
import org.sql.exception.GeneratorException;
import org.sql.generator.SelectSql;
import org.sql.item.DefaultItem;
import org.sql.type.Match;


/**
 * TuNGɂǗNX.
 * <P>
 * r̐́ArIuWFNgbp[NX
 * i<a href="Comparisons.html">com.sn.sql.comparison.Comparisons</a>jgp܂B<br>
 * <br>
 * <ul>
 *     <li>TuNGݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 = (SELECT COLUMN2 FROM TABLE2 WHERE COLUMN2 = '')</font><br>
 *         <br>
 *         @SelectColumn column = new SelectColumn();<br>
 *         @column.append("COLUMN2");<br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("COLUMN2", ""));<br>
 *         <br>
 *         @SelectSql subSql = new SelectSql("TABLE2", column);<br>
 *         @subSql.addCondition(condition);<br>
 *         <br>
 *         @column.clear();<br>
 *         @condition.clear();<br>
 *         <br>
 *         @condition.and(Comparisons.query("COLUMN1", subSql, Match.EQ));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", column);<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 *
 * @author S.Nagashiba
 */
public class SubQueryComparison extends AbstractBindComparison {

	/** r@ */
	private Match match = null;
	
	/**
	 * RXgN^
	 * @param column J
	 * @param value  SQL
	 * @param match  r@
	 */
    public SubQueryComparison(String column, SelectSql value, Match match) {
        createComparison(column, value, match);
    }
    
    /**
     * r擾
     * @param column J
     * @param value  SQL
     * @param match  r@
     */
    protected void createComparison(String column, SelectSql value, Match match) {
       	DefaultItem item = new DefaultItem();
       	item.put(column, value);
        super.setComparison(item);
        this.match = match;
    }
    
	/**
	 * r쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createComparison(DefaultItem item) throws ComparisonException {
		StringBuffer sb = new StringBuffer();
        try {
    		sb.append(item.getColumn());
    		sb.append(this.match.toTypeString());
    		sb.append(" ( " + ((SelectSql) item.getValue()[0]).getSql() + ")");
        }
        catch (GeneratorException e) {
            super.setException(e);
        }
		return sb.toString();
	}
	
	/**
	 * oChr쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createBindComparison(DefaultItem item) throws ComparisonException {
		StringBuffer sb = new StringBuffer();
        try {
    		sb.append(item.getColumn());
    		sb.append(this.match.toTypeString());
    		sb.append(" ( " + ((SelectSql) item.getValue()[0]).getBindSql() + ")");
        }
        catch (GeneratorException e) {
            super.setException(e);
        }
		return sb.toString();
	}
}
