/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import org.sql.exception.ComparisonException;
import org.sql.exception.GeneratorException;
import org.sql.generator.Sql;
import org.sql.item.DefaultItem;


/**
 * EXISTSǗNX.
 * 
 * @author S.Nagashiba
 */
public class ExistsComparison extends AbstractBindComparison {

	/** NOT EXISTS[true]AEXISTS[false] */
	private boolean not = false;
	
	/**
	 * RXgN^
	 * @param sql SQLIuWFNg
	 */
    public ExistsComparison(Sql sql) {
        createComparison(sql, false);
    }
    
	/**
	 * RXgN^
	 * @param sql SQLIuWFNg
	 * @param not NOT EXISTS[true]AEXISTS[false]
	 */
    public ExistsComparison(Sql sql, boolean not) {
        createComparison(sql, true);
    }
    
    /**
     * r쐬
	 * @param sql SQLIuWFNg
	 * @param not NOT EXISTS[true]AEXISTS[false]
     */
    protected void createComparison(Sql sql, boolean not) {
    	DefaultItem item = new DefaultItem();
    	item.put(null, sql);
        super.setComparison(item);
        this.not = not;
    }
    
	/**
	 * r쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createComparison(DefaultItem item) throws ComparisonException {
		StringBuffer sb = new StringBuffer();
        try {
            if (not) {
            	sb.append(" NOT");
            }
    		sb.append(" EXISTS (");
    		sb.append(((Sql) item.getValue()[0]).getSql());
    		sb.append(")");
        }
        catch (GeneratorException e) {
            super.setException(e);
        }
		return sb.toString();
	}
	
	/**
	 * oChr쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createBindComparison(DefaultItem item) throws ComparisonException {
		StringBuffer sb = new StringBuffer();
        try {
            if (not) {
            	sb.append(" NOT");
            }
    		sb.append(" EXISTS (");
    		sb.append(((Sql) item.getValue()[0]).getBindSql());
    		sb.append(")");
        }
        catch (GeneratorException e) {
            super.setException(e);
        }
		return sb.toString();
	}
}
