/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import java.util.Date;

import org.sql.exception.ComparisonException;
import org.sql.exception.FormatException;
import org.sql.item.DefaultItem;
import org.sql.message.Message;
import org.sql.type.Format;
import org.sql.type.Function;
import org.sql.util.GeneratorUtil;


/**
 * rǗׂ̊{NX.
 * 
 * @author S.Nagashiba
 */
public abstract class AbstractComparison implements Comparison {

	/** t - N */
    private static String ORA_YMD = Format.YMD.toTypeString();
	/** t - b */
    private static String ORA_HMS = Format.HMS.toTypeString();
	/** t - Nb */
    private static String ORA_YMD_HMS = Format.YMD_HMS.toTypeString();
	
	/** t - N */
	private static String JAVA_YMD = "yyyy/MM/dd";
	/** t - b */
	private static String JAVA_HMS = "HH:mm:ss";
	/** t - Nb */
	private static String JAVA_YMD_HMS = "yyyy/MM/dd HH:mm:ss";
	
	/**  */
	private DefaultItem comparison  = new DefaultItem();
	
	/** O */
	private Throwable exception = null;

	/**
	 * RXgN^iȂ̃CX^XȂj
	 */
	protected AbstractComparison() {}
	
	/**
	 * ݒ肷
	 * @param comparison 
	 */
	protected void setComparison(DefaultItem comparison) {
		this.comparison = comparison;
	}
	
	/**
	 * 擾
	 * @return 
	 * @throws ComparisonException rO
	 */
	public String toComparisonString() throws ComparisonException {
		if (exception != null) {
			throw new ComparisonException(exception);
		}
		return createComparison(this.comparison);
	}
	
	/**
	 * TO_DATE̎擾
	 * @param value l
	 * @param format IuWFNg
	 * @return TO_DATE
	 * @throws FormatException O
	 */
	protected final String toDate(Date value, Format format) throws FormatException {
		String todate = null;
		String toformat = format.toTypeString();
		
		if (toformat.equals(ORA_YMD)) {
			todate = GeneratorUtil.dateToStr(value, JAVA_YMD);
		}
		else if (toformat.equals(ORA_HMS)){
			todate = GeneratorUtil.dateToStr(value, JAVA_HMS);
		}
		else if (toformat.equals(ORA_YMD_HMS)){
			todate = GeneratorUtil.dateToStr(value, JAVA_YMD_HMS);
		}
		else {
		    throw new FormatException(Message.getInstance("SQL-002"));
		}
		return Function.toDate(todate, toformat).toTypeString();
	}
	
	/**
	 * NA
	 */
	public void clear() {
		this.comparison = null;
	}
	
	/**
	 * Oݒ肷
	 * @param exception O
	 */
	protected void setException(Throwable exception) {
		this.exception = exception;
	}
	
	/**
	 * O擾
	 * @return O
	 */
	public Throwable getException() {
	    return this.exception;
	}
	
	/**
	 * r쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected abstract String createComparison(DefaultItem item) throws ComparisonException;
}
