/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generator;

import org.sql.column.RegistColumn;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.AbstractRegistSql;
import org.sql.message.Message;
import org.sql.util.GeneratorUtil;

public class UpdateSql
extends AbstractRegistSql {
    public UpdateSql(String table) {
        super(table);
    }

    public UpdateSql(String table, RegistColumn column) {
        super(table);
        super.setColumn(column);
    }

    public String getSql() throws GeneratorException {
        StringBuffer result = new StringBuffer();
        if (this.condition == null) {
            super.setCondition(new Condition());
        }
        if (!GeneratorUtil.isNaming(this.getFrom())) {
            throw new GeneratorException(Message.getInstance("SQL-001", this.getFrom()));
        }
        result.append("UPDATE ");
        result.append(this.getFrom());
        result.append(" SET " + super.getColumn().toColumnString());
        result.append(this.condition.getCondition());
        return result.toString();
    }

    public String getBindSql() throws GeneratorException {
        StringBuffer result = new StringBuffer();
        if (this.condition == null) {
            super.setCondition(new Condition());
        }
        result.append("UPDATE ");
        result.append(this.getFrom());
        result.append(" SET ");
        result.append(this.getBindVariable());
        result.append(this.condition.getCondition());
        return result.toString();
    }

    protected String getBindVariable() {
        StringBuffer result = new StringBuffer();
        Object[] key = super.getColumn().getMap().keySet().toArray();
        for (int i = 0; i < key.length; ++i) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(key[i] + " = ?");
        }
        return result.toString();
    }
}

