/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generator;

import java.util.Map;
import org.sql.column.RegistColumn;
import org.sql.exception.GeneratorException;
import org.sql.generator.AbstractRegistSql;
import org.sql.message.Message;
import org.sql.util.GeneratorUtil;

public class InsertSql
extends AbstractRegistSql {
    public InsertSql(String table) {
        super(table);
    }

    public InsertSql(String table, RegistColumn column) {
        super(table);
        super.setColumn(column);
    }

    public String getSql() throws GeneratorException {
        StringBuffer result = new StringBuffer();
        if (!GeneratorUtil.isNaming(this.getFrom())) {
            throw new GeneratorException(Message.getInstance("SQL-001", this.getFrom()));
        }
        result.append("INSERT INTO " + this.getFrom());
        result.append(" (" + this.getColumnString() + ") VALUES (" + this.getValue() + ")");
        return result.toString();
    }

    public String getBindSql() throws GeneratorException {
        StringBuffer result = new StringBuffer();
        result.append("INSERT INTO " + this.getFrom());
        result.append(" (" + this.getColumnString() + ") VALUES (" + this.getBindVariable() + ")");
        return result.toString();
    }

    private String getColumnString() {
        StringBuffer result = new StringBuffer();
        Object[] key = super.getColumn().getMap().keySet().toArray();
        for (int i = 0; i < key.length; ++i) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(key[i]);
        }
        return result.toString();
    }

    private String getValue() {
        StringBuffer result = new StringBuffer();
        Map map = super.getColumn().getMap();
        Object[] key = map.keySet().toArray();
        for (int i = 0; i < key.length; ++i) {
            if (result.length() > 0) {
                result.append(", ");
            }
            if (map.get(key[i]) == null) {
                result.append("NULL");
                continue;
            }
            if (map.get(key[i]) instanceof String) {
                result.append("'");
                result.append(map.get(key[i]));
                result.append("'");
                continue;
            }
            result.append(map.get(key[i]));
        }
        return result.toString();
    }

    protected String getBindVariable() {
        StringBuffer result = new StringBuffer();
        Object[] key = super.getColumn().getMap().keySet().toArray();
        for (int i = 0; i < key.length; ++i) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("?");
        }
        return result.toString();
    }
}

