/*
 * Decompiled with CFR 0.152.
 */
package org.sql.comparison;

import java.util.Date;
import java.util.List;
import org.sql.comparison.BetweenComparison;
import org.sql.comparison.Comparison;
import org.sql.comparison.ExistsComparison;
import org.sql.comparison.InComparison;
import org.sql.comparison.LikeComparison;
import org.sql.comparison.NullComparison;
import org.sql.comparison.SimpleComparison;
import org.sql.comparison.SubQueryComparison;
import org.sql.generator.SelectSql;
import org.sql.type.Format;
import org.sql.type.LikeMatch;
import org.sql.type.Match;
import org.sql.type.Null;

public final class Comparisons {
    private Comparisons() {
    }

    public static Comparison eqNot(String column, Object value) {
        return new SimpleComparison(column, value, Match.NOT_EQ);
    }

    public static Comparison eqNot(String column, Date value, Format format) {
        return new SimpleComparison(column, value, format, Match.NOT_EQ);
    }

    public static Comparison eq(String column, Object value) {
        return new SimpleComparison(column, value, Match.EQ);
    }

    public static Comparison eq(String column, Date value, Format format) {
        return new SimpleComparison(column, value, format, Match.EQ);
    }

    public static Comparison ge(String column, Object value) {
        return new SimpleComparison(column, value, Match.GE);
    }

    public static Comparison ge(String column, Date value, Format format) {
        return new SimpleComparison(column, value, format, Match.GE);
    }

    public static Comparison gt(String column, Object value) {
        return new SimpleComparison(column, value, Match.GT);
    }

    public static Comparison gt(String column, Date value, Format format) {
        return new SimpleComparison(column, value, format, Match.GT);
    }

    public static Comparison le(String column, Object value) {
        return new SimpleComparison(column, value, Match.LE);
    }

    public static Comparison le(String column, Date value, Format format) {
        return new SimpleComparison(column, value, format, Match.LE);
    }

    public static Comparison lt(String column, Object value) {
        return new SimpleComparison(column, value, Match.LT);
    }

    public static Comparison lt(String column, Date value, Format format) {
        return new SimpleComparison(column, value, format, Match.LT);
    }

    public static Comparison in(String column, List value) {
        return new InComparison(column, value);
    }

    public static Comparison in(String column, Object[] value) {
        return new InComparison(column, value);
    }

    public static Comparison like(String column, LikeMatch match) {
        return new LikeComparison(column, match);
    }

    public static Comparison between(String column, Object value1, Object value2) {
        return new BetweenComparison(column, value1, value2);
    }

    public static Comparison isNull(String column) {
        return new NullComparison(column, Null.NULL);
    }

    public static Comparison isNotNull(String column) {
        return new NullComparison(column, Null.NOT_NULL);
    }

    public static Comparison exists(SelectSql sql) {
        return new ExistsComparison(sql);
    }

    public static Comparison existsNot(SelectSql sql) {
        return new ExistsComparison(sql, true);
    }

    public static Comparison query(String column, SelectSql sql, Match match) {
        return new SubQueryComparison(column, sql, match);
    }
}

