/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;


/**
 * SQLp[eBeBNX
 * 
 * @author S.Nagashiba
 */
public final class GeneratorUtil {

    /** vpeBtH_ */
    private static final String PROPERTIES_DIR = "com.sn.sql.properties.";

	/**
	 * RXgN^iÕCX^XȂj
	 */
	private GeneratorUtil() {}
	
	/**
	 * Ώۖ̂'A'-'Z','a'-'z','0'-'9','-','_'ȊO܂܂邩mF
	 * @param  name Ώۖ
	 * @return trueAfalse
	 */
    public static boolean isNaming(String name) {
	    boolean result = true;
		char charData;
		for (int i=0;i < name.length();i++) {
			charData = name.charAt(i);   
			if (((charData < 'A') || (charData > 'Z')) 
					&& ((charData < 'a') || (charData > 'z')) 
					&& ((charData < '0') || (charData > '9'))
					&& (charData != '-')
					&& (charData != '_')
				)
			{
			    result = false;
			    break;
			}
		}
		return result;
	}
	
	/**
	 * ƂďOie[uA\A֐Ȃǁj邩mF
	 * @param value Ώە
	 * @return O[true]AOȂ[false]
	 */
    public static boolean isExclusion(String value) {
	    if ((value.indexOf("{") > -1) && (value.indexOf("}") > -1)) {
	        return true;
	    }
	    else {
	        return false;
	    }
	}
    
	/**
	 * O̕񕔕i{}j擾
	 * @param value Ώە
	 * @return O̕񕔕
	 */
    public static String getExclusion(String value) {
        String str = value.substring(1, value.length());
		return str.substring(0, str.length() - 1);
    }
    
	/**
	 * java.util.Date  java.sql.Timestamp ɕϊ
	 * @param date java.util.Date
	 * @return java.sql.Timestamp
	 */
	public static Timestamp parseStamp(Date date) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		return new Timestamp(cal.getTimeInMillis());
	}
	
	/**
	 * t𕶎ɕϊ
	 * @param date t
	 * @param fmt tH[}bg
	 * @return ϊ
	 */
	public static String dateToStr(Date date, String fmt) {
		//ttH[}bgݒ
		SimpleDateFormat SD = new SimpleDateFormat(fmt,Locale.JAPAN);

		//twtH[}bg֕ϊ
		String sYMD = SD.format(date);

		if (sYMD == null) sYMD = "";
		return sYMD;
	}
	
	/**
	 * IuWFNg]AStringIuWFNgł΃NH[e[Vň͂񂾒lԋp
	 * @param object ΏۃIuWFNg
	 * @return ]ꂽIuWFNg
	 */
	public static String toQuoteString(Object object) {
        return (object instanceof String ? "'" + object.toString() + "'" : object.toString());
	}
	
	/**
	 * IuWFNg]AƂďOie[uA\A֐Ȃǁj邩mF<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	 * OΏۂł΁AO̕񕔕i{}jԋp<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	 * OΏۂłȂꍇAStringIuWFNgł΃NH[e[Vň͂񂾒lԋp<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	 * ȊȌꍇAIuWFNg̕\ԋp
	 * @param object ΏۃIuWFNg
	 * @return ]ꂽIuWFNg
	 */
	public static String toExclusionString(Object object) {
	    return (isExclusion(object.toString()) ? getExclusion(object.toString()) : toQuoteString(object));
	}
}
