/*
 * SQL Generator
 * 
 * Copyright (c) 2005, Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.type;


/**
 * W֐ǗNX
 *
 * @author S.Nagashiba
 */
public final class SetFunction implements Types {

    /** ֐ */
    private String function;
    /** J */
	private String column;
    /** GCAX */
	private String as;
	
    /**
     * RXgN^
     * @param function ֐
     * @param column J
     * @param as GCAX
     */
	private SetFunction(String function, String column, String as) {
        this.function = function;
		this.column = column;
		this.as = as;
    }
    
	/**
	 * ʕ擾
	 * @return ʕ
	 */
	public String toTypeString() {
		StringBuffer str = new StringBuffer();
		str.append(this.function);
		str.append("(");
		str.append(this.column);
		str.append(")");
	    str.append(" AS " + this.as);
		return str.toString();
	}
    
    /**
     * a߂IuWFNg擾
     * @param column J
     * @param as GCAX
     * @return W֐IuWFNg
     */
    public static SetFunction sum(String column, String as) {
        return new SetFunction("SUM", column, as);
    }
    
    /**
     * ől߂IuWFNg擾
     * @param column J
     * @param as GCAX
     * @return W֐IuWFNg
     */
    public static SetFunction max(String column, String as) {
        return new SetFunction("MAX", column, as);
    }
    
    /**
     * ŏl߂IuWFNg擾
     * @param column J
     * @param as GCAX
     * @return W֐IuWFNg
     */
    public static SetFunction min(String column, String as) {
        return new SetFunction("MIN", column, as);
    }
    
    /**
     * ϒl߂IuWFNg擾
     * @param column J
     * @param as GCAX
     * @return W֐IuWFNg
     */
    public static SetFunction avg(String column, String as) {
        return new SetFunction("AVG", column, as);
    }
    
    /**
     * ߂IuWFNg擾
     * @param column J
     * @param as GCAX
     * @return W֐IuWFNg
     */
    public static SetFunction count(String column, String as) {
        return new SetFunction("COUNT", column, as);
    }
}
