/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.type;

/**
 * r@ǗNX
 *
 * @author S.Nagashiba
 */
public final class Match implements Types {

    /** r@ */
	private int matchMode;

	/** r@ - v */
	private static final int SUB_MATCH_EQ = 0;
	/** r@ - sv */
	private static final int SUB_MATCH_NOT_EQ = 1;
	/** r@ - ȉ */
	private static final int SUB_MATCH_LE = 2;
	/** r@ -  */
	private static final int SUB_MATCH_LT = 3;
	/** r@ - ȏ */
	private static final int SUB_MATCH_GE = 4;
	/** r@ - 傫 */
	private static final int SUB_MATCH_GT = 5;
	/** r@ - ꂩ */
	private static final int SUB_MATCH_IN = 6;

	/** r@[h - v */
	public static final Match EQ = new Match(SUB_MATCH_EQ);
	/** r@[h - sv */
	public static final Match NOT_EQ = new Match(SUB_MATCH_NOT_EQ);
	/** r@[h - ȉ */
	public static final Match LE = new Match(SUB_MATCH_LE);
	/** r@[h -  */
	public static final Match LT = new Match(SUB_MATCH_LT);
	/** r@[h - ȏ */
	public static final Match GE = new Match(SUB_MATCH_GE);
	/** r@[h - 傫 */
	public static final Match GT = new Match(SUB_MATCH_GT);
	/** r@[h - ꂩ */
	public static final Match IN = new Match(SUB_MATCH_IN);
	
	/**
	 * RXgN^
	 * @param joinMode r@[h
	 */
	private Match(int joinMode) {
		this.matchMode = joinMode;
	}
	
	/**
	 * r@擾
	 * @return bN
	 */
	public String toTypeString() {
		String ret = null;
		switch (this.matchMode) {
			case SUB_MATCH_EQ: ret = " = "; break;
			case SUB_MATCH_NOT_EQ: ret = " <> "; break;
			case SUB_MATCH_LE: ret = " <= "; break;
			case SUB_MATCH_GE: ret = " >= "; break;
			case SUB_MATCH_IN: ret = " IN "; break;
		}
		return ret;
	}
}
