/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.type;


/**
 * \ǗNX
 *
 * @author S.Nagashiba
 */
public class Join implements Types {

    /** \ */
	private int joinMode;
	
	/** \ -  */
	private static final int INNER_JOIN = 0;
	/** \ - O */
	private static final int OUTER_JOIN = 1;
	/** \ -  */
	private static final int LEFT_JOIN = 2;
	/** \ - E */
	private static final int RIGHT_JOIN = 3;
	
	/** ꂽJOIN𐶐 */
	public static final Join INNER = new Join(INNER_JOIN);
	/** OꂽJOIN𐶐 */
	public static final Join OUTER = new Join(OUTER_JOIN);
	/** ꂽJOIN𐶐 */
	public static final Join LEFT = new Join(LEFT_JOIN);
	/** EꂽJOIN𐶐 */
	public static final Join RIGHT = new Join(RIGHT_JOIN);

	/**
	 * RXgN^
	 * @param joinMode \
	 * @param handler  f[^x[XʂʂIuWFNg
	 */
	private Join(int joinMode) {
		this.joinMode = joinMode;
	}
	
	/**
	 * \擾
	 * @return \
	 */
	public String toTypeString() {
		String ret = null;
		switch (this.joinMode) {
			case INNER_JOIN: ret = " INNER JOIN "; break;
			case OUTER_JOIN: ret = " OUTER JOIN "; break;
			case LEFT_JOIN : ret = " LEFT JOIN "; break;
			case RIGHT_JOIN: ret = " RIGHT JOIN "; break;
	    }
		return ret;
	}
}
