/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.generator;

import org.sql.column.RegistedColumn;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.message.Message;
import org.sql.util.GeneratorUtil;



/**
 * XVSQLNX.
 * 
 * <P>
 * XVAe[uAݒ肵܂B<br>
 * <br>
 * ݒ肳ꂽeIuWFNgSQL\z܂B<br>
 * <br>
 * <b>Java\[XTv</b><br>
 * <table><tr><td class="SampleCode">
 *         j<font color="blue">UPDATE TABLE1 SET COLUMN1 = '', COLUMN2 = '' WHERE COLUMN3 = ''</font><br>
 *         <br>
 *         @RegistedColumn column = new RegistedColumn();<br>
 *         @column.append("COLUMN1", "");<br>
 *         @column.append("COLUMN2", "");<br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("COLUMN3", ""));<br>
 *         @<br>
 *         @UpdateSql sql = new UpdateSql("TABLE1", column);<br>
 *         @sql.setCondition(condition);<br>
 * </td></tr></table>
 * <P>
 *
 * @author S.Nagashiba
 */
public class UpdateSql extends AbstractRegistedSql {

	/**
	 * RXgN^
	 * @param table e[u
	 */
	public UpdateSql(String table) {
		super(table);
	}
	
	/**
	 * RXgN^
	 * @param table e[u
	 * @param column XVJ
	 */
	public UpdateSql(String table, RegistedColumn column) {
		super(table);
		super.setColumn(column);
	}
	
	/**
	 * SQL擾
	 * @return SQL
	 * @throws GeneratorException SQLO
	 */
	public String getSql() throws GeneratorException {
		StringBuffer result = new StringBuffer();
		if (super.condition == null) {
			super.setCondition(new Condition());
		}
		if (!GeneratorUtil.isNaming(getFrom())) {
		    throw new GeneratorException(Message.getInstance("SQL-001", getFrom()));
		}
		result.append("UPDATE ");
		result.append(getFrom());
		result.append(" SET " + super.getRegistedColumn().toColumnString());
		result.append(super.condition.getCondition());
		return result.toString();
	}
	
	/**
	 * ߍ݌^SQL擾
	 * @return ߍ݌^SQL
	 */
	public String getBindSql() throws GeneratorException {
		StringBuffer result = new StringBuffer();
		if (super.condition == null) {
			super.setCondition(new Condition());
		}
		result.append("UPDATE ");
		result.append(getFrom());
		result.append(" SET ");
		result.append(getBindVariable());
		result.append(super.condition.getCondition());
		return result.toString();
	}
	
	/**
	 * oChϐ擾
	 * @return oChϐ
	 */
	protected String getBindVariable() {
		StringBuffer result = new StringBuffer();
		Object[] key = super.getRegistedColumn().getMap().keySet().toArray();
		for (int i = 0; i < key.length; i++) {
			if (result.length() > 0) result.append(", ");
			result.append(key[i] + " = ?");
		}
		return result.toString();
	}
}
