/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.generator;

import org.sql.exception.GeneratorException;
import org.sql.type.Order;


/**
 * UNION SQL𐶐NX.
 * 
 * <P>
 * eSQLIuWFNgݒ肵܂B<br>
 * <br>
 * <b>Java\[XTv</b><br>
 * <table><tr><td class="SampleCode">
 *         j<font color="blue">
 *         @@SELECT * FROM TABLE1 WHERE COLUMN1 = ''<br>
 *         @@UNION<br>
 *         @@SELECT * FROM TABLE2 WHERE COLUMN1 = ''<br>
 *         @@ORDER BY COLUMN1 ASC, COLUMN2 DESC</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql1 = new SelectSql("TABLE1");<br>
 *         @SelectSql sql2 = new SelectSql("TABLE2");<br>
 *         @<br>
 *         @sql1.setCondition(condition);<br>
 *         @sql2.setCondition(condition);<br>
 *         <br>
 *         @Order[] order = new Order[2];<br>
 *         @order[0] = Order.asc("COLUMN1");<br>
 *         @order[1] = Order.desc("COLUMN2");<br>
 *         <br>
 *         @UnionSql sql = new UnionSql();<br>
 *         @sql.union(new SelectSql[]{sql1, sql2});<br>
 *         @sql.addOrder(order);<br>
 * </td></tr></table>
 * <br>
 * <b>Java\[XTv</b><br>
 * <table><tr><td class="SampleCode">
 *         j<font color="blue">
 *         @@SELECT * FROM TABLE1 WHERE COLUMN1 = ''<br>
 *         @@UNION ALL<br>
 *         @@SELECT * FROM TABLE2 WHERE COLUMN1 = ''<br>
 *         @@ORDER BY COLUMN1 ASC, COLUMN2 DESC</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql1 = new SelectSql("TABLE1");<br>
 *         @SelectSql sql2 = new SelectSql("TABLE2");<br>
 *         @<br>
 *         @sql1.setCondition(condition);<br>
 *         @sql2.setCondition(condition);<br>
 *         <br>
 *         @Order[] order = new Order[2];<br>
 *         @order[0] = Order.asc("COLUMN1");<br>
 *         @order[1] = Order.desc("COLUMN2");<br>
 *         <br>
 *         @UnionSql sql = new UnionSql();<br>
 *         @sql.unionAll(new SelectSql[]{sql1, sql2});<br>
 *         @sql.addOrder(order);<br>
 * </td></tr></table>
 * <P>
 *
 * @author S.Nagashiba
 */
public class UnionSql extends AbstractSql implements OrderBy {

    /** SQLA@ UNION ALL[true]AUNION[false] */
	private boolean unionMode = false;
	/** SQLIuWFNg */
	private Sql[] sql = null;
	/** \[g */
	private StringBuffer order = new StringBuffer();
	
	/**
	 * ASQLIuWFNgݒ肷
	 * 
	 * @param sql SQLIuWFNg
	 * @param unionMode UNION ALL[true]AUNION[false]
	 */
	private void union(Sql[] sql, boolean unionMode) {
		this.sql = sql;
		this.unionMode = unionMode;
	}
	
	/**
	 * ASQLIuWFNgݒ肷ids܂Ƃ߂A@j
	 * 
	 * @param sql SQLIuWFNg
	 */
	public void union(Sql[] sql) {
		this.union(sql, false);
	}
	
	/**
	 * ASQLIuWFNgݒ肷iSĂ̍s\A@j
	 * 
	 * @param sql SQLIuWFNg
	 */
	public void unionAll(Sql[] sql) {
		this.union(sql, true);
	}
	
	/**
	 * SQLXe[gg擾
	 * @return SQLXe[gg
	 * @throws SQLO
	 */
	public String getSql() throws GeneratorException {
		StringBuffer result = new StringBuffer();
		for (int i = 0; i < sql.length; i++) {
		    if (result.toString().length() > 0) {
		        result.append(unionMode ? " UNION ALL " : " UNION ");
		    }
		    result.append(this.sql[i].getSql());
		}
	    result.append(this.order.toString());
		return result.toString();
	}
	
	/**
	 * \[gǉ
	 * @param order \[gIuWFNg
	 */
	public void addOrder(Order order) {
		if (this.order.length() == 0) {
			this.order.append(" ORDER BY ");
		}
		else {
			this.order.append(",");
		}
		this.order.append(order.toTypeString());
	}

	/**
	 * \[gǉ
	 * @param orders \[gIuWFNgz
	 */
	public void addOrder(Order[] orders) {
		for (int i = 0; i < orders.length; i++) {
			addOrder(orders[i]);
		}
	}
	
	/**
	 * NA
	 */
	public void clear() {
	    this.sql = null;
	    this.order = null;
	}
}
