/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.generator;

import org.sql.column.Column;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.message.Message;
import org.sql.type.Group;
import org.sql.type.Lock;
import org.sql.type.Order;
import org.sql.util.GeneratorUtil;



/**
 * Pe[uQSQL𐶐NX.
 * 
 * <P>
 * JAe[uAA\[gݒ肵܂B<br>
 * <br>
 * ݒ肳ꂽeIuWFNgSQL\z܂B<br>
 * <br>
 * <b>Java\[XTv</b><br>
 * <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 = '' ORDER BY COLUMN1 ASC, COLUMN2 DESC</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("COLUMN1", ""));<br>
 *         <br>
 *         @Order[] order = new Order[2];<br>
 *         @order[0] = Order.asc("COLUMN1");<br>
 *         @order[1] = Order.desc("COLUMN2");<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.setCondition(condition);<br>
 *         @sql.addOrder(order);<br>
 * </td></tr></table>
 * <P>
 *
 * @author S.Nagashiba
 */
public class SelectSql extends AbstarctSimpleSql implements OrderBy, GroupBy {

	/** \[g */
    private StringBuffer order = null;
	/** bN */
    private String lockString = "";
	/** J */
	private Column column = null;
	/** O[v */
	private Group group = null;
	/** DISTINCT */
	private boolean distinct = false;
	
	/**
	 * RXgN^
	 * @param table e[u
	 */
	public SelectSql(String table) {
		super(table);
	}
	
	/**
	 * RXgN^
	 * @param table e[u
	 * @param column J
	 */
	public SelectSql(String table, Column column) {
		super(table);
		this.setColumn(column);
	}
	
	/**
	 * RXgN^
	 * @param table e[u
	 * @param distinct dsr[true]AdsrȂ[false]
	 */
	public SelectSql(String table, boolean distinct) {
		this(table);
		this.distinct = distinct;
	}
	
	/**
	 * RXgN^
	 * @param table e[u
	 * @param column J
	 * @param distinct dsr[true]AdsrȂ[false]
	 */
	public SelectSql(String table, Column column, boolean distinct) {
		this(table, column);
		this.distinct = distinct;
	}
	
	/**
	 * Jǉ
	 * @param column J
	 */
	public void setColumn(Column column) {
	    this.column = column;
	}
	
	/**
	 * SQLXe[gg擾
	 * @return SQLXe[gg
	 * @throws GeneratorException SQLO
	 */
	public String getSql() throws GeneratorException {
		StringBuffer result = new StringBuffer();
		if (super.condition == null) {
			super.setCondition(new Condition());
		}
		if (!GeneratorUtil.isNaming(getFrom())) {
		    throw new GeneratorException(Message.getInstance("SQL-001", getFrom()));
		}
		result.append("SELECT ");
		if (this.distinct) {
		    result.append("DISTINCT ");
		}
		result.append(this.column.toColumnString());
		result.append(" FROM " + getFrom());
		result.append(super.condition.getCondition());
		result.append(this.lockString);
		if (this.group != null) {
		    result.append(" GROUP BY " + this.group.toTypeString());
		}
		if (this.order != null) {
		    result.append(" ORDER BY " + this.order.toString());
		}
		return result.toString();
	}
	
	/**
	 * \[gǉ
	 * @param order \[gIuWFNg
	 */
	public void addOrder(Order order) {
		if (this.order.length() > 0) {
			this.order.append(",");
		}
		this.order.append(order.toTypeString());
	}

	/**
	 * \[gǉ
	 * @param orders \[gIuWFNgz
	 */
	public void addOrder(Order[] orders) {
		for (int i = 0; i < orders.length; i++) {
		    addOrder(orders[i]);
		}
	}

	/** bN */
	public void lock(Lock lockmode) {
		this.lockString = " " + lockmode.toTypeString();
	}
	
	/**
	 * J擾
	 * @return J
	 */
	public Column getColumn() {
		return this.column;
	}
	
	/**
	 * NA
	 */
	public void clear() {
		clearFrom();
	    super.getCondition().clear();
		this.column.clear();
		this.order.delete(0, this.order.length());
		this.lockString = "";
	}
	
	/**
	 * O[vǉ
	 * @param group O[vIuWFNg
	 */
    public void addGroup(Group group) {
        this.group = group;
    }
}
