/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.generator;

import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.message.Message;
import org.sql.util.GeneratorUtil;


/**
 * 폜SQLNX
 * 
 * <P>
 * e[uAݒ肵܂B<br>
 * <br>
 * ݒ肳ꂽeIuWFNgSQL\z܂B<br>
 * <br>
 * <b>Java\[XTv</b><br>
 * <table><tr><td class="SampleCode">
 *         j<font color="blue">DELETE FROM TABLE1 WHERE COLUMN1 = ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("COLUMN1", ""));<br>
 *         @<br>
 *         @DeleteSql sql = new DeleteSql("TABLE1", column);<br>
 *         @sql.setCondition(condition);<br>
 * </td></tr></table>
 * <P>
 *
 * @author S.Nagashiba
 */
public class DeleteSql extends AbstarctSimpleSql {

	/**
	 * RXgN^
	 * @param table e[u
	 */
	public DeleteSql(String table) {
		super(table);
	}

	/**
	 * SQL擾
	 * @return SQL
	 * @throws GeneratorException SQLO
	 */
	public String getSql() throws GeneratorException {
		StringBuffer result = new StringBuffer();
		if (super.condition == null) {
			super.setCondition(new Condition());
		}
		if (!GeneratorUtil.isNaming(getFrom())) {
		    throw new GeneratorException(Message.getInstance("SQL-001", getFrom()));
		}
		result.append("DELETE");
		result.append(" FROM " + getFrom());
		result.append(super.condition.getCondition());
		return result.toString();
	}
	
	/**
	 * NA
	 */
	public void clear() {
		clearFrom();
	    super.getCondition().clear();
	}
}
