/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.condition;

import org.sql.comparison.AbstractComparison;
import org.sql.comparison.Comparison;
import org.sql.exception.ComparisonException;


/**
 * ǗNX.
 * 
 * <P>
 * <ul>
 *     <li>WHERE ` ANDŔrݒ肷ꍇ́Aand\bhgp܂B<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 = '' AND COLUMN2 = ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("COLUMN1", ""));<br>
 *         @condition.and(Comparisons.eq("COLUMN2", ""));<br>
 *         @<br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());
 *         @sql.setCondition(condition);
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>WHERE ` ORŔrݒ肷ꍇ́Aor\bhgp܂B<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 = '' OR COLUMN2 = ''</font><br>
 *         @<br>
 *         @Condition condition = new Condition();<br>
 *         @condition.or(Comparisons.eq("COLUMN1", ""));<br>
 *         @condition.or(Comparisons.eq("COLUMN2", ""));<br>
 *         @<br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());
 *         @sql.setCondition(condition);
 *     </td></tr></table>
 * </ul>
 * <P>
 *
 * @author S.Nagashiba
 */
public final class Condition extends AbstractCondition {

    /** WHERE[0]AAND[1]AOR[2] */
    private int iCondition;
    
    /** WHERE */
    private static final int INT_WHERE = 0;
    /** AND */
    private static final int INT_AND = 1;
    /** OR */
    private static final int INT_OR = 2;
    
	/**
	 * RXgN^
	 */
	public Condition() {
		super();
	}
	
	/**
	 * WHERE ` ANDݒ肷
	 * @param comparison rIuWFNg
	 */
	public void and(Comparison comparison) {
	    if (super.isEmpty()) {
		    this.iCondition = INT_WHERE;
	    }
	    else {
	        this.iCondition = INT_AND;
	    }
	    createCondition(comparison);
	}
	
	/**
	 * WHERE ` ORݒ肷
	 * @param comparison rIuWFNg
	 */
	public void or(Comparison comparison) {
	    if (super.isEmpty()) {
		    this.iCondition = INT_WHERE;
	    }
	    else {
	        this.iCondition = INT_OR;
	    }
	    createCondition(comparison);
	}
	
	/**
	 * 𐶐
	 * @param comparison r
	 * @param or OR[true]AAND[false]
	 */
	private void createCondition(Comparison comparison) {
	    //rɗO΁ÃNXɗOݒ肵
	    if (((AbstractComparison) comparison).getException() != null) {
	        this.setException(((AbstractComparison) comparison).getException());
	        return;
	    }
	    try {
	        String str = null;
	        switch (iCondition) {
	        	case INT_WHERE: str = " WHERE "; break;
	        	case INT_AND  : str = " AND ";   break;
	        	case INT_OR   : str = " OR ";    break;
	        }
	        super.setCondition(str + comparison.toComparisonString());
	    }
	    catch (ComparisonException e) {
	        this.setException(e);
	    }
	}
}
