/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import java.util.Date;

import org.sql.exception.FormatException;
import org.sql.type.Format;
import org.sql.type.Match;
import org.sql.util.GeneratorUtil;


/**
 * ʓIȔrǗNX.
 * <P>
 * r̐́ArIuWFNgbp[NX
 * i<a href="Comparisons.html">com.sn.sql.comparison.Comparisons</a>jgp܂B<br>
 * <br>
 * <ul>
 *     <li>Svݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 = ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>sSvݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 <> ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eqNot("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>ȏݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 >= ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.ge("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>ȉݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 <= ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.le("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>傫ݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 > ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.gt("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>ݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 < ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.lt("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 *
 * @author S.Nagashiba
 */
public class SimpleComparison extends AbstractComparison {

    /** r@ */
    private String property = null;
    
	/**
	 * RXgN^iȂ̃CX^XȂj
	 */
	protected SimpleComparison() {}
	
	/**
	 * RXgN^
	 * @param column J
	 * @param value  l
	 * @param match  r@
	 */
	public SimpleComparison(String column, Object value, Match match) {
	    setProperty(match.toTypeString());
	    createComparison(column, value);
	}
	
	/**
	 * RXgN^
	 * @param column J
	 * @param value  l
	 * @param format IuWFNg
	 * @param match  r@
	 */
	public SimpleComparison(String column, Date value, Format format, Match match) {
	    setProperty(match.toTypeString());
	    createComparison(column, value, format);
	}
	
	/**
	 * rݒ肷
	 * @param column J
	 * @param value  l
	 */
	protected void createComparison(String column, Object value) {
		if (value instanceof Date) {
		    createComparison(column, (Date) value, Format.YMD_HMS);
		}
		else {
			super.setComparison(column + property + GeneratorUtil.toExclusionString(value));
		}
	}
	
	/**
	 * rݒ肷
	 * @param column J
	 * @param value  l
	 * @param format IuWFNg
	 */
	protected void createComparison(String column, Date value, Format format) {
	    try {
	        super.setComparison(column + property + toDate(value, format));
	    }
	    catch (FormatException e) {
	        super.setException(e);
	    }
	}
	
	/**
	 * r@ݒ肷
	 * @param property r@
	 */
	protected final void setProperty(String property) {
	    this.property = property;
	}
}
