/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import org.sql.type.Null;


/**
 * NULLǗNX.
 * <P>
 * r̐́ArIuWFNgbp[NX
 * i<a href="Comparisons.html">com.sn.sql.comparison.Comparisons</a>jgp܂B<br>
 * <br>
 * <ul>
 *     <li>NULLݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 IS NULL</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.isNull("COLUMN1"));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>NOT NULLݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 IS NOT NULL</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.isNotNull("COLUMN1"));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 *
 * @author S.Nagashiba
 */
public class NullComparison extends AbstractComparison {

    /** NULL */
    private String property = null;
    
    /**
     * RXgN^
     * @param column J
     * @param nullMode NULL
     */
    public NullComparison(String column, Null nullMode) {
        this.property = nullMode.toTypeString();
        createComparison(column);
    }
    
    /**
     * 쐬
     * @param column J
     */
    protected void createComparison(String column) {
        super.setComparison(column + " IS " + property);
    }
}
