/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import org.sql.type.LikeMatch;
import org.sql.util.GeneratorUtil;

/**
 * LIKEǗNX.
 * <P>
 * r̐́ArIuWFNgbp[NX
 * i<a href="Comparisons.html">com.sn.sql.comparison.Comparisons</a>jgp܂B<br>
 * <br>
 * <ul>
 *     <li>Svݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 LIKE ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.like("COLUMN1", LikeMatch.exact("")));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>Ovݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 LIKE '%'</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.like("COLUMN1", LikeMatch.start("")));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>vݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 LIKE '%'</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.like("COLUMN1", LikeMatch.end("")));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>Ovݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 LIKE '%%'</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.like("COLUMN1", LikeMatch.anywhere("")));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 *
 * @author S.Nagashiba
 */
public class LikeComparison extends AbstractComparison {

	/**
	 * RXgN^
	 * @param column J
	 * @param match  vIuWFNg
	 */
	public LikeComparison(String column, LikeMatch match) {
		createComparison(column, match);
	}
	
	/**
	 * vǉ
	 * @param column J
	 * @param match  vIuWFNg
	 */
	public void createComparison(String column, LikeMatch match) {
		super.setComparison(column + " like " + GeneratorUtil.toQuoteString(match.toTypeString()));
	}
}
