/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import java.util.List;

import org.sql.util.GeneratorUtil;

/**
 * INǗNX.
 * <P>
 * r̐́ArIuWFNgbp[NX
 * i<a href="Comparisons.html">com.sn.sql.comparison.Comparisons</a>jgp܂B<br>
 * <br>
 * <ul>
 *     <li>INݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 IN (1, 2, 3)</font><br>
 *         <br>
 *         @List list = new ArrayList();<br>
 *         @list.add(new Integer(1));<br>
 *         @list.add(new Integer(2));<br>
 *         @list.add(new Integer(3));<br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.in("COLUMN1", list));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 *
 * @author S.Nagashiba
 */
public class InComparison extends AbstractComparison {

    
	/**
	 * RXgN^
	 * @param column J
	 * @param value  l
	 */
    public InComparison(String column, List value) {
	    this(column, value.toArray());
	}
	
	/**
	 * RXgN^
	 * @param column J
	 * @param value  l
	 */
	public InComparison(String column, Object[] value) {
	    createComparison(column, value);
	}
	
	/**
	 * r쐬
	 * @param column J
	 * @param value  l
	 */
	protected void createComparison(String column, Object[] value) {
		super.setComparison((" IN ("));
		for (int i = 0; i < value.length; i++) {
			super.setComparison(GeneratorUtil.toQuoteString(value[i]));

			if (i != (value.length - 1)) {
				super.setComparison((","));
			}
		}
		super.setComparison((")"));
	}
}
