/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import org.sql.exception.GeneratorException;
import org.sql.generator.Sql;



/**
 * EXISTSǗNX
 * 
 * @author S.Nagashiba
 */
public class ExistsComparison extends AbstractComparison {

	/**
	 * RXgN^
	 * @param sql SQLIuWFNg
	 */
    public ExistsComparison(Sql sql) {
        createComparison(sql, false);
    }
    
	/**
	 * RXgN^
	 * @param sql SQLIuWFNg
	 * @param not NOT EXISTS[true]AEXISTS[false]
	 */
    public ExistsComparison(Sql sql, boolean not) {
        createComparison(sql, true);
    }
    
    /**
     * r쐬
	 * @param sql SQLIuWFNg
	 * @param not NOT EXISTS[true]AEXISTS[false]
     */
    protected void createComparison(Sql sql, boolean not) {
        StringBuffer comparison = new StringBuffer();
        try {
            if (not) {
                comparison.append(" NOT");
            }
            comparison.append(" EXISTS (");
            comparison.append(sql.getSql());
            comparison.append(")");
            super.setComparison(comparison.toString());
        }
        catch (GeneratorException e) {
            super.setException(e);
        }
    }
}
