/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import java.util.Date;
import java.util.List;

import org.sql.generator.SelectSql;
import org.sql.type.Format;
import org.sql.type.LikeMatch;
import org.sql.type.Match;
import org.sql.type.Null;


/**
 * rIuWFNgbp[NX.
 * 
 * <P>
 * <ul>
 *     <li>rlJ̏ꍇ́A{}ň݂͂܂B<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         @Comparisons.eq("COLUMN1", "{COLUMN2}");<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>rlt̏ꍇ́Aݒ肵܂B<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         @Comparisons.eq("COLUMN1", new Date(), Format.YMD);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>rll̏ꍇ́Abv^ݒ肵܂B<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         @Comparisons.eq("COLUMN1", new Integer(0));<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>rقȂe[ui<a href="..\generator\JoinSql.html">JoinSql</a>y\SQLIuWFNgzgpj̏ꍇ́A<br>
 *         JɃe[u.e[uJݒ肵܂B<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("TABLE1.COLUMN1", "{TABLE2.COLUMN2}"));<br>
 *         <br>
 *         @JoinSql sql = new JoinSql();<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 *
 * @author S.Nagashiba
 */
public final class Comparisons {

	/**
	 * RXgN^iÕCX^XȂj
	 */
	private Comparisons() {}
	
	/**
	 * sSvIuWFNg
	 * 
	 * @param column J
	 * @param value  li<b>e[uJݒ</b>j
	 * @return rIuWFNg
	 */
	public static Comparison eqNot(String column, Object value) {
	    return new SimpleComparison(column, value, Match.NOT_EQ);
	}
	
	/**
	 * sSvIuWFNg
	 * @param column J
	 * @param value  li<b>e[uJݒ</b>j
	 * @param format IuWFNg
	 * @return rIuWFNg
	 */
	public static Comparison eqNot(String column, Date value, Format format) {
	    return new SimpleComparison(column, value, format, Match.NOT_EQ);
	}
	
	/**
	 * SvIuWFNg
	 * @param column J
	 * @param value  li<b>e[uJݒ</b>j
	 * @return rIuWFNg
	 */
	public static Comparison eq(String column, Object value) {
	    return new SimpleComparison(column, value, Match.EQ);
	}
	
	/**
	 * SvIuWFNg
	 * @param column J
	 * @param value  li<b>e[uJݒ</b>j
	 * @param format IuWFNg
	 * @return rIuWFNg
	 */
	public static Comparison eq(String column, Date value, Format format) {
	    return new SimpleComparison(column, value, format, Match.EQ);
	}
	
	/**
	 * ȏIuWFNg
	 * @param column J
	 * @param value  li<b>e[uJݒ</b>j
	 * @return rIuWFNg
	 */
	public static Comparison ge(String column, Object value) {
	    return new SimpleComparison(column, value, Match.GE);
	}
	
	/**
	 * ȏIuWFNg
	 * @param column J
	 * @param value  li<b>e[uJݒ</b>j
	 * @param format IuWFNg
	 * @return rIuWFNg
	 */
	public static Comparison ge(String column, Date value, Format format) {
	    return new SimpleComparison(column, value, format, Match.GE);
	}
	
	/**
	 * 傫IuWFNg
	 * @param column J
	 * @param value  li<b>e[uJݒ</b>j
	 * @return rIuWFNg
	 */
	public static Comparison gt(String column, Object value) {
	    return new SimpleComparison(column, value, Match.GT);
	}
	
	/**
	 * 傫IuWFNg
	 * @param column J
	 * @param value  li<b>e[uJݒ</b>j
	 * @param format IuWFNg
	 * @return rIuWFNg
	 */
	public static Comparison gt(String column, Date value, Format format) {
	    return new SimpleComparison(column, value, format, Match.GT);
	}
	
	/**
	 * ȉIuWFNg
	 * @param column J
	 * @param value  li<b>e[uJݒ</b>j
	 * @return rIuWFNg
	 */
	public static Comparison le(String column, Object value) {
	    return new SimpleComparison(column, value, Match.LE);
	}
	
	/**
	 * ȉIuWFNg
	 * @param column J
	 * @param value  li<b>e[uJݒ</b>j
	 * @param format IuWFNg
	 * @return rIuWFNg
	 */
	public static Comparison le(String column, Date value, Format format) {
	    return new SimpleComparison(column, value, format, Match.LE);
	}
	
	/**
	 * IuWFNg
	 * @param column J
	 * @param value  li<b>e[uJݒ</b>j
	 * @return rIuWFNg
	 */
	public static Comparison lt(String column, Object value) {
	    return new SimpleComparison(column, value, Match.LT);
	}
	
	/**
	 * IuWFNg
	 * @param column J
	 * @param value  li<b>e[uJݒ</b>j
	 * @param format IuWFNg
	 * @return rIuWFNg
	 */
	public static Comparison lt(String column, Date value, Format format) {
	    return new SimpleComparison(column, value, format, Match.LT);
	}
	
	/**
	 * INIuWFNg
	 * @param column J
	 * @param value  li<b>e[uJݒ<font color="red">s</font></b>j
	 * @return rIuWFNg
	 */
	public static Comparison in(String column, List value) {
	    return new InComparison(column, value);
	}
	
	/**
	 * INIuWFNg
	 * @param column J
	 * @param value  li<b>e[uJݒ<font color="red">s</font></b>j
	 * @return rIuWFNg
	 */
	public static Comparison in(String column, Object[] value) {
	    return new InComparison(column, value);
	}
	
	/**
	 * vIuWFNg
	 * @param column J
	 * @param match  vIuWFNg
	 * @return rIuWFNg
	 */
	public static Comparison like(String column, LikeMatch match) {
	    return new LikeComparison(column, match);
	}
	
	/**
	 * ͈͏IuWFNg
	 * @param column J
	 * @param value1 l1i<b>e[uJݒ<font color="red">s</font></b>j
	 * @param value2 l2i<b>e[uJݒ<font color="red">s</font></b>j
	 * @return rIuWFNg
	 */
	public static Comparison between(String column, Object value1, Object value2) {
	    return new BetweenComparison(column, value1, value2);
	}
	
	/**
	 * NULLIuWFNg
	 * @param column J
	 * @return rIuWFNg
	 */
	public static Comparison isNull(String column) {
	    return new NullComparison(column, Null.NULL);
	}
	
	/**
	 * NOT NULLIuWFNg
	 * @param column J
	 * @return rIuWFNg
	 */
	public static Comparison isNotNull(String column) {
	    return new NullComparison(column, Null.NOT_NULL);
	}
	
	/**
	 * EXISTSIuWFNg
	 * @param sql SQLIuWFNg
	 * @return rIuWFNg
	 */
	public static Comparison exists(SelectSql sql) {
	    return new ExistsComparison(sql);
	}
	
	/**
	 * NOT EXISTSIuWFNg
	 * @param sql SQLIuWFNg
	 * @return rIuWFNg
	 */
	public static Comparison existsNot(SelectSql sql) {
	    return new ExistsComparison(sql, true);
	}
	
	/**
	 * TuNGIuWFNg
	 * @param column J
	 * @param sql    SQLIuWFNg
	 * @param match  r@
	 * @return rIuWFNg
	 */
	public static Comparison query(String column, SelectSql sql, Match match) {
	    return new SubQueryComparison(column, sql, match);
	}
}
