/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import org.sql.util.GeneratorUtil;


/**
 * BETWEENǗNX.
 * <P>
 * r̐́ArIuWFNgbp[NX
 * i<a href="Comparisons.html">com.sn.sql.comparison.Comparisons</a>jgp܂B<br>
 * <br>
 * <ul>
 *     <li>BETWEENݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 BETWEEN 0 AND 99</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.between("COLUMN1", new Integer(0), new Integer(99)));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn());<br>
 *         @sql.addCondition(condition);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 *
 * @author S.Nagashiba
 */
public class BetweenComparison extends AbstractComparison {

	/**
	 * r擾
	 * @param column J
	 * @param value1 l1
	 * @param value2 l2
	 */
    public BetweenComparison(String column, Object value1, Object value2) {
        createComparison(column, value1, value2);
    }
    
    /**
     * r𐶐
	 * @param column J
	 * @param value1 l1
	 * @param value2 l2
     */
    protected void createComparison(String column, Object value1, Object value2) {
        StringBuffer comparison = new StringBuffer();
        comparison.append(column);
        comparison.append(" BETWEEN ");
        comparison.append(GeneratorUtil.toQuoteString(value1));
        comparison.append(" AND ");
        comparison.append(GeneratorUtil.toQuoteString(value2));
        super.setComparison(comparison.toString());
    }
}
