/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.column;

import java.util.Map;

import org.sql.exception.GeneratorException;
import org.sql.generator.SelectSql;
import org.sql.type.Types;


/**
 * JǗNX
 *
 * @author S.Nagashiba
 */
public class SelectColumn extends AbstractColumn {

    /**
     * RXgN^
     */
    public SelectColumn() {
        super();
    }
    
    /**
     * RXgN^
     * @param column J
     */
    public SelectColumn(String column) {
        append(column);
    }
    
    /**
     * RXgN^
     * @param columns Jz
     */
    public SelectColumn(String[] columns) {
        append(columns);
    }
    
	/**
	 * Jǉ
	 * @param arg ʂǗIuWFNg
	 * @param as  GCAX
	 */
	public void append(Types arg, String as) {
        super.append(arg.toTypeString() + " AS " + as);
	}
	
	/**
	 * Jǉ
	 * @param column J
	 * @param as GCAX
	 */
	public void append(Object column, String as) {
        super.append(column.toString() + " AS " + as);
	}
	
	/**
	 * Jǉ
	 * @param columns Jz
	 */
	public void append(String[] columns) {
		for (int i = 0; i < columns.length; i++) {
		    super.append(columns[i]);
		}
	}
	
	/**
	 * Jǉ
	 * @param columns Jz
	 * @param as GCAXz
	 */
	public void append(String[] columns, String[] as) {
		for (int i = 0; i < columns.length; i++) {
			append(columns[i], as[i]);
		}
	}
	
	/**
	 * Jǉ
	 * @param map JƃGCAX̃}bv
	 */
	public void append(Map map) {
	    Object[] key = map.keySet().toArray();
	    for (int i = 0; i < key.length; i++) {
	        append(key[i].toString(), map.get(key[i]).toString());
	    }
	}
	
	/**
	 * Jǉ
	 * @param arg J
	 * @param as GCAX
	 * @throws GeneratorException SQLO
	 */
	public void appendSql(SelectSql arg, String as) throws GeneratorException {
        super.append("(" + arg.getSql() + ") AS " + as);
	}
	
	/**
	 * J擾
	 * @return J
	 */
	public String toColumnString() {
		if (!super.isColumn()) {
		    super.append("*");
		}
		return super.toColumnString();
	}
}
