/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.xml.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.xml.XMLBuildException;
import com.ozacc.mail.xml.XMLBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.internet.InternetAddress;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class JDomXMLBuilder
implements XMLBuilder {
    public static final String DOCTYPE_PUBLIC = "-//OZACC//DTD MAIL//EN";
    public static final String DOCTYPE_SYSTEM = "http://www.ozacc.com/library/dtd/ozacc-mail.dtd";
    private String charset = "UTF-8";

    public JDomXMLBuilder() {
    }

    public JDomXMLBuilder(String charset) {
        this();
        this.setCharset(charset);
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public org.w3c.dom.Document buildDocument(Mail mail) throws XMLBuildException {
        Document doc = this.buildJDomDocument(mail);
        DOMOutputter outputter = new DOMOutputter();
        try {
            return outputter.output(doc);
        }
        catch (JDOMException e) {
            throw new XMLBuildException("DOM Document\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public Document buildJDomDocument(Mail mail) {
        Element mailElem = new Element("mail");
        if (mail.getReturnPath() != null) {
            InternetAddress returnPath = mail.getReturnPath();
            Element returnPathElem = this.convertInternetAddressIntoElement(returnPath, "returnPath");
            mailElem.addContent((Content)returnPathElem);
        }
        if (mail.getFrom() != null) {
            InternetAddress from = mail.getFrom();
            Element fromElem = this.convertInternetAddressIntoElement(from, "from");
            mailElem.addContent((Content)fromElem);
        }
        if (mail.getTo().length > 0 || mail.getCc().length > 0 || mail.getBcc().length > 0) {
            Element recipientsElem = new Element("recipients");
            if (mail.getTo().length > 0) {
                for (int i = 0; i < mail.getTo().length; ++i) {
                    InternetAddress to = mail.getTo()[i];
                    Element toElem = this.convertInternetAddressIntoElement(to, "to");
                    recipientsElem.addContent((Content)toElem);
                }
            }
            if (mail.getCc().length > 0) {
                for (int i = 0; i < mail.getCc().length; ++i) {
                    InternetAddress cc = mail.getCc()[i];
                    Element ccElem = this.convertInternetAddressIntoElement(cc, "cc");
                    recipientsElem.addContent((Content)ccElem);
                }
            }
            if (mail.getBcc().length > 0) {
                for (int i = 0; i < mail.getBcc().length; ++i) {
                    InternetAddress bcc = mail.getBcc()[i];
                    Element bccElem = this.convertInternetAddressIntoElement(bcc, "bcc");
                    recipientsElem.addContent((Content)bccElem);
                }
            }
            mailElem.addContent((Content)recipientsElem);
        }
        if (mail.getReplyTo() != null) {
            InternetAddress replyTo = mail.getReplyTo();
            Element replyToElem = this.convertInternetAddressIntoElement(replyTo, "replyTo");
            mailElem.addContent((Content)replyToElem);
        }
        if (mail.getSubject() != null) {
            Element subjectElem = new Element("subject");
            subjectElem.setText(mail.getSubject());
            mailElem.addContent((Content)subjectElem);
        }
        if (mail.getText() != null) {
            Element textElem = new Element("body");
            textElem.setText(mail.getText());
            mailElem.addContent((Content)textElem);
        }
        if (mail.isHtmlMail()) {
            Element htmlElem = new Element("html");
            htmlElem.setContent((Content)new CDATA(mail.getHtmlText()));
            mailElem.addContent((Content)htmlElem);
        }
        Document doc = new Document(mailElem);
        DocType docType = new DocType("mail", DOCTYPE_PUBLIC, DOCTYPE_SYSTEM);
        doc.setDocType(docType);
        return doc;
    }

    private Element convertInternetAddressIntoElement(InternetAddress address, String elemName) {
        Element element = new Element(elemName);
        element.setAttribute("email", address.getAddress());
        if (address.getPersonal() != null) {
            element.setAttribute("name", address.getPersonal());
        }
        return element;
    }

    public void saveDocument(Mail mail, File destFile) throws XMLBuildException {
        Document doc = this.buildJDomDocument(mail);
        try {
            FileOutputStream fos = new FileOutputStream(destFile);
            XMLOutputter outputter = this.getXMLOutputter();
            outputter.output(doc, (OutputStream)fos);
            fos.close();
        }
        catch (IOException e) {
            throw new XMLBuildException("DOM Document\u306e\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public XMLOutputter getXMLOutputter() {
        Format format = Format.getPrettyFormat();
        format.setEncoding(this.charset);
        XMLOutputter outputter = new XMLOutputter(format);
        return outputter;
    }
}

