/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch.impl.sk_jp.text;

import com.ozacc.mail.fetch.impl.sk_jp.text.Translator;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class EntityRefEncoder
implements Translator {
    public static final EntityRefEncoder CANONICAL_INSTANCE = new EntityRefEncoder(true);
    public static final EntityRefEncoder INSTANCE = new EntityRefEncoder(false);
    private boolean canonicalStatus;

    public EntityRefEncoder() {
        this(false);
    }

    public EntityRefEncoder(boolean canonical) {
        this.setCanonical(canonical);
    }

    private void setCanonical(boolean canonical) {
        this.canonicalStatus = canonical;
    }

    public void translate(Reader r, Writer w) throws IOException {
        int c;
        while ((c = r.read()) != -1) {
            EntityRefEncoder.translate((char)c, w, this.canonicalStatus);
        }
        w.flush();
    }

    public String translate(String source) {
        return EntityRefEncoder.encode(source);
    }

    public static String encode(String s) {
        if (s == null) {
            return "";
        }
        int len = s.length();
        StringBuffer buf = new StringBuffer(len + 128);
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return new String(buf);
    }

    public static void translate(char c, Writer w, boolean canonical) throws IOException {
        switch (c) {
            case '<': {
                w.write("&lt;");
                break;
            }
            case '>': {
                w.write("&gt;");
                break;
            }
            case '&': {
                w.write("&amp;");
                break;
            }
            case '\"': {
                w.write("&quot;");
                break;
            }
            case '\n': 
            case '\r': {
                if (canonical) {
                    w.write("&#");
                    w.write(Integer.toString(c));
                    w.write(59);
                    break;
                }
                w.write(c);
                break;
            }
            default: {
                w.write(c);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String decode(String s) {
        if (s == null) {
            return "";
        }
        len = s.length();
        buf = new StringBuffer(len);
        i = 0;
        while (i < len) {
            block11: {
                block12: {
                    block10: {
                        c = s.charAt(i);
                        if (c == '&' && i <= len - 4) break block10;
                        buf.append(c);
                        break block11;
                    }
                    if (s.charAt(i + 2) != 't' && s.charAt(i + 2) != 'T' || s.charAt(i + 3) != ';') break block12;
                    switch (s.charAt(i + 1)) {
                        case 'L': 
                        case 'l': {
                            buf.append('<');
                            i += 3;
                            break block11;
                        }
                        case 'G': 
                        case 'g': {
                            buf.append('>');
                            i += 3;
                            break block11;
                        }
                    }
                    ** GOTO lbl-1000
                }
                if (!(i >= len - 4 || s.charAt(i + 1) != 'a' && s.charAt(i + 1) != 'A' || s.charAt(i + 2) != 'm' && s.charAt(i + 2) != 'M' || s.charAt(i + 3) != 'p' && s.charAt(i + 3) != 'P' || s.charAt(i + 4) != ';')) {
                    buf.append('&');
                    i += 4;
                } else if (!(i >= len - 5 || s.charAt(i + 1) != 'q' && s.charAt(i + 1) != 'Q' || s.charAt(i + 2) != 'u' && s.charAt(i + 2) != 'U' || s.charAt(i + 3) != 'o' && s.charAt(i + 3) != 'O' || s.charAt(i + 4) != 't' && s.charAt(i + 4) != 'T' || s.charAt(i + 5) != ';')) {
                    buf.append('\"');
                    i += 5;
                } else lbl-1000:
                // 2 sources

                {
                    buf.append(c);
                }
            }
            ++i;
        }
        return new String(buf);
    }
}

