/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch.impl.sk_jp;

import com.ozacc.mail.fetch.impl.sk_jp.CorrectedContentTypeDataSource;
import com.ozacc.mail.fetch.impl.sk_jp.io.ByteToCharUTF7;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParseException;

class CorrectedContentTypeDataSourceUTF7Support
extends CorrectedContentTypeDataSource {
    private boolean utf7 = false;

    public CorrectedContentTypeDataSourceUTF7Support() {
    }

    public CorrectedContentTypeDataSourceUTF7Support(DataSource dataSource, String defaultCharset) {
        super(dataSource, defaultCharset);
    }

    public CorrectedContentTypeDataSourceUTF7Support(Part part, String defaultCharset) throws MessagingException {
        super(part, defaultCharset);
    }

    public void setDataSource(DataSource newSource) {
        super.setDataSource(newSource);
        this.utf7 = false;
    }

    public void setDefaultCharset(String defaultCharset) {
        super.setDefaultCharset(defaultCharset);
        this.utf7 = false;
    }

    public String getContentType() {
        try {
            ContentType contentType = new ContentType(super.getContentType());
            String specifiedCharset = contentType.getParameter("charset");
            if ("UTF-7".equalsIgnoreCase(specifiedCharset)) {
                contentType.setParameter("charset", "UTF-16");
                this.utf7 = true;
            }
            return contentType.toString();
        }
        catch (ParseException e) {
            throw new InternalError();
        }
    }

    public InputStream getInputStream() throws IOException {
        int c;
        InputStream in;
        block6: {
            in = null;
            if (this.isInvalidEncodingAsMultipart()) {
                in = this.getRawInputStream();
            }
            if (in == null) {
                try {
                    in = super.getInputStream();
                }
                catch (IOException e) {
                    in = this.getRawInputStream();
                    if (in != null) break block6;
                    throw e;
                }
            }
        }
        if (!this.utf7) {
            return in;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        ByteToCharUTF7 btc = new ByteToCharUTF7();
        byte[] bytes = out.toByteArray();
        char[] chars = new char[bytes.length];
        int len = btc.convert(bytes, 0, bytes.length, chars, 0, chars.length);
        char[] w = new char[len];
        System.arraycopy(chars, 0, w, 0, len);
        String string = new String(w);
        return new ByteArrayInputStream(string.getBytes("UTF-16"));
    }

    private InputStream getRawInputStream() throws IOException {
        if (!(this.source instanceof MessageAware)) {
            return null;
        }
        Part part = ((MessageAware)this.source).getMessageContext().getPart();
        try {
            if (part instanceof MimeMessage) {
                return ((MimeMessage)part).getRawInputStream();
            }
            if (part instanceof MimeBodyPart) {
                return ((MimeBodyPart)part).getRawInputStream();
            }
            return null;
        }
        catch (MessagingException mex) {
            throw new IOException(mex.toString());
        }
    }

    private boolean isInvalidEncodingAsMultipart() {
        block6: {
            block5: {
                if (new ContentType(this.getContentType()).match("multipart/*")) break block5;
                return false;
            }
            if (this.source instanceof MessageAware) break block6;
            return false;
        }
        try {
            Part part = ((MessageAware)this.source).getMessageContext().getPart();
            String encoding = ((MimePart)part).getEncoding();
            if ("7bit".equalsIgnoreCase(encoding) || "8bit".equalsIgnoreCase(encoding) || "binary".equalsIgnoreCase(encoding)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

