/*
 * @(#) $Id: UnicodeCorrector.java,v 1.1.2.1 2005/01/18 07:20:36 otsuka Exp $
 * $Revision: 1.1.2.1 $
 * Copyright (c) 2000 Shin Kinoshita All Rights Reserved.
 */
package com.ozacc.mail.fetch.impl.sk_jp.io;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

/**
 * UnicodeCorrector.
 * <p>
 * CorrectOutputStreamWriterѤʸХåե饹Ǥ<br>
 * ϥ󥳡ǥ󥰤ˤä٤ʸɤۤʤΤǡ
 * ºݤϥ֥饹ǹԤޤ<br>
 *
 * бƤΤϰʲΥС̾Ǥ
 * </p>
 * <UL>
 * <LI>ISO2022JP
 * <LI>ISO-2022-JP
 * <LI>EUC-JP
 * <LI>EUCJIS
 * <LI>SJIS
 * <LI>Shift_JIS
 * <LI>MS932
 * <LI>Windows-31J
 * </UL>
 * @author Shin
 * @version $Revision: 1.1.2.1 $ $Date: 2005/01/18 07:20:36 $
 */
public abstract class UnicodeCorrector {
    private static final Map correctorMap = new HashMap();
    static {
        // x-sjis-cp932ǤѴ줿Unicode¾Υ󥳡ǥ󥰤
        // ϤǤ
        correctorMap.put("iso2022jp", FromCP932Corrector.class);
        correctorMap.put("iso-2022-jp", FromCP932Corrector.class);
        correctorMap.put("euc-jp", FromCP932Corrector.class);
        correctorMap.put("eucjis", FromCP932Corrector.class);
        // Ʊ"SJIS"ǤSunMS-VMǤϰۤʤޤ
        // Sun-JDK1.1SJISx-sjis-jdk-1.1.7ǡMS-VMx-sjis-cp932Ǥ
        // MS-JDKΥ饹饤֥x-sjis-jdk-1.1.7ˤʤΤ
        // äΤǤ(ե񤭽ФΤȤΤߤʤ)
        // Windowsͥƥ֤Ѵɽ줿Unicode
        // x-sjis-jdk-1.1.7ǽϤ뤿ΤΤǤ
        correctorMap.put("sjis", FromCP932Corrector.class);
        correctorMap.put("shift_jis", FromCP932Corrector.class);
        // MS-VMǥեϤԤ˸¤ꡢǤʤФʤޤ
        //      correctorMap.put("sjis", ToCP932Corrector.class);
        // JDK1.2WindowsΥǥեȤ"MS932"(x-sjis-cp932)Ȥʤޤ
        // ǡ¾Υ󥳡ǥ󥰤Ѵ줿()Unicode"ms932"
        // ǤνϻˤʤäƤޤޤ
        // ޤ
        correctorMap.put("ms932", ToCP932Corrector.class);
        correctorMap.put("windows-31j", ToCP932Corrector.class);
    }

    /**
     * Create an UnicodeCorrector that uses
     * the named character encoding.
     * @param  enc  Name of the encoding to be used
     * @exception  UnsupportedEncodingException
     *             If the named encoding is not supported
     */
    public static UnicodeCorrector getInstance(String enc)
            throws UnsupportedEncodingException {
        Class correctorClass = (Class)correctorMap.get(enc.toLowerCase());
        if (correctorClass == null) {
            throw new UnsupportedEncodingException(enc);
        }
        try {
            return (UnicodeCorrector)correctorClass.newInstance();
        } catch (Exception e) {
            throw new UnsupportedEncodingException(
                    correctorClass + " cannot get newInstance.\n" + e);
        }
    }

    /**
     * UnicodeʸԤޤ
     * <p>
     * ʸꥨ󥳡ǥ󥰤ǽϤ褦Ȥݤ
     * sun.ioСǤѴǤʤʬޤ
     * </p>
     * @param  cbuf  Buffer of characters
     * @param  off   Offset from which to start writing characters
     * @param  len   Number of characters to write
     * @return Result that corrected.
     *         Note:Return array is different from <code>cbuf</code>
     *              in case of different result size.
     */
    public char[] correct(char cbuf[], int off, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = off; i < len; i++) {
            buf.append(correct(cbuf[i]));
        }
        return new String(buf).toCharArray();
    }

    public String correct(String s) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); i++) {
            buf.append(correct(s.charAt(i)));
        }
        return new String(buf);
    }

    // ǽŪˤabstractˤΤϤä
    public abstract char correct(char c);

    /**
     * UnicodeCorrectorɲäޤ
     * <p>
     * ΥɤѤˡưŪ˿ʽϥ󥳡ǥ󥰤
     * бUnicodeCorrectorϿѤޤ
     * </p>
     * @param enc б륨󥳡ǥ̾
     * @param correctorClass UnicodeCorrector֥饹Class֥
     */
    public static void addCorrector(String enc, Class correctorClass) {
        if (!correctorClass.isInstance(UnicodeCorrector.class)) {
            throw new IllegalArgumentException(
                    "Corrector is not UnicodeCorrector type.");
        }
        correctorMap.put(enc, correctorClass);
    }
}