package com.ozacc.blog.ping.impl;

import junit.framework.TestCase;

import org.apache.xmlrpc.Echo;
import org.apache.xmlrpc.WebServer;

import com.ozacc.blog.ping.FailedUpdatePingException;
import com.ozacc.blog.ping.UpdatePingClient;
import com.ozacc.blog.ping.UpdatePingResponseException;

/**
 * XmlRpcUpdatePingClientのテストケース。
 * 
 * @author Tomohiro Otsuka
 * @version $Id: XmlRpcUpdatePingClientTest.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class XmlRpcUpdatePingClientTest extends TestCase {

	private UpdatePingClient client;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		client = new XmlRpcUpdatePingClient();
	}

	public void testPingToInvalidServer() throws Exception {
		String blogName = "Example";
		String blogUrl = "http://www.example.com/";

		WebServer server = new WebServer(8080);
		server.addHandler("weblogUpdates", new Echo());
		server.start();
		String host = "http://127.0.0.1:8080";
		try {
			String message = client.ping(host, blogName, blogUrl);
			fail("UpdatePingException should have been called.");
		} catch (UpdatePingResponseException expected) {
			assertEquals("対応していないフォーマットのレスポンスが返されました。", expected.getMessage());
		} finally {
			server.shutdown();
		}
	}

	/**
	 * http://ping.blo.gs のレスポンス。
	 * {message=Succeeded., flerror=false}
	 * 
	 * http://rpc.weblogs.com/RPC2 のレスポンス
	 * {message=Thanks for the ping., flerror=false}
	 */
	public void testPingToWeblogsWithError() throws Exception {
		String blogName = "TestCase";
		String blogUrl = "";
		String host = "http://ping.blo.gs";
		try {
			String message = client.ping(host, blogName, blogUrl);
			fail("UpdatePingException should have been called.");
		} catch (FailedUpdatePingException e) {
			System.out.println("Message [" + e.getMessage() + "]");
		}
	}
	
	/*public void testPingToBloggersReal() throws Exception {
		String blogName = "XXX Blog";
		String blogUrl = "http://blog.example.com/";
		String host = "http://ping.bloggers.jp/rpc/";
		String message = client.ping(host, blogName, blogUrl);
		System.out.println(message);
	}*/
	
}