package com.ozacc.blog.feed.impl;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;

import com.ozacc.blog.feed.Channel;
import com.ozacc.blog.feed.impl.FeedParserImpl;

/**
 * RSSParserImplのテストケース。
 * 
 * @author Tomohiro Otsuka
 * @version $Id: FeedParserImplTest.java 198 2005-08-10 01:43:46Z otsuka $
 */
public class FeedParserImplTest extends TestCase {

	private FeedParserImpl parser;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		BasicConfigurator.configure();

		parser = new FeedParserImpl();
		
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
		BasicConfigurator.resetConfiguration();
	}

	/*
	 * Channel parseRSS のテスト中のクラス(String)
	 */
	public final void testParseRSSString() throws Exception {
		String rssUrl = "http://spring-ext.sourceforge.jp/blog/index.rdf";
		Channel channel = parser.parseFeed(rssUrl);

		/*RSSGenerator gen = new RSSGeneratorImpl();
		 File f = new File("target/test/data/index.rdf");
		 f.getParentFile().mkdirs();
		 gen.write(channel, f, RSSVersion.RSS_1_0);*/

		assertNotNull(channel);
		assertEquals("Spring Extensions", channel.getTitle());
		assertEquals("http://spring-ext.sourceforge.jp/blog/", channel.getLink().toString());
	}

}