package com.ozacc.blog.util;

import org.apache.commons.httpclient.HttpStatus;

/**
 * commons-httpclientの使用時に利用するユーティリティクラス。
 * 
 * @since 1.2.4
 * @author Tomohiro Otsuka
 * @version $Id: CommonsHttpClientUtils.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class CommonsHttpClientUtils {

	private CommonsHttpClientUtils() {};

	/**
	 * 指定されたcommons-httpclientのレスポンスコードが成功を示すものかどうか判定します。
	 * 
	 * @param statusCode commons-httpclientのレスポンスコード
	 * @param followRedirect リダイレクトレスポンスを成功とみなす場合は true を指定
	 * @return 成功を示すレスポンスコードの場合 true
	 */
	public static boolean isSuccessfulResponse(int statusCode, boolean followRedirect) {
		if (followRedirect) {
			return (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_MOVED_TEMPORARILY
					|| statusCode == HttpStatus.SC_MOVED_PERMANENTLY || statusCode == HttpStatus.SC_TEMPORARY_REDIRECT);
		} else {
			return statusCode == HttpStatus.SC_OK;
		}
	}
}