package com.ozacc.blog.trackback;

import java.io.Serializable;

/**
 * トラックバックPing。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: TrackBackPing.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class TrackBackPing implements Serializable, Cloneable {

	private String title;

	private String excerpt;

	private String url;

	private String blogName;

	private String charset;

	/**
	 * コンストラクタ。
	 */
	public TrackBackPing() {
		super();
	}

	/**
	 * コンストラクタ。
	 * 
	 * @param title
	 * @param excerpt
	 * @param url
	 * @param blogName
	 */
	public TrackBackPing(String title, String excerpt, String url, String blogName) {
		this.title = title;
		this.excerpt = excerpt;
		this.url = url;
		this.blogName = blogName;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("[TrackBackPing ");
		buf.append("title='" + title + "', ");
		buf.append("excerpt='" + excerpt + "', ");
		buf.append("url='" + url + "', ");
		buf.append("blogName='" + blogName + "'");
		if (charset != null) {
			buf.append(", charset='" + charset + "'");
		}
		buf.append("]");
		return buf.toString();
	}

	/**
	 * @return 文字コード
	 */
	public String getCharset() {
		return charset;
	}

	/**
	 * @param charset 文字コード
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * @return Returns ブログ名
	 */
	public String getBlogName() {
		return blogName;
	}

	/**
	 * @param blogName ブログ名
	 */
	public void setBlogName(String blogName) {
		this.blogName = blogName;
	}

	/**
	 * @return ブログ記事本文の抜粋、要約
	 */
	public String getExcerpt() {
		return excerpt;
	}

	/**
	 * @param excerpt ブログ記事本文の抜粋、要約
	 */
	public void setExcerpt(String excerpt) {
		this.excerpt = excerpt;
	}

	/**
	 * @return ブログ記事のタイトル
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * @param title ブログ記事のタイトル
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * @return ブログ記事のURL
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * @param url ブログ記事のURL
	 */
	public void setUrl(String url) {
		this.url = url;
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	public Object clone() {
		TrackBackPing ping = new TrackBackPing(title, excerpt, url, blogName);
		ping.setCharset(charset);
		return ping;
	}
}