package com.ozacc.blog.trackback;

import java.io.UnsupportedEncodingException;

import javax.servlet.http.HttpServletRequest;

/**
 * 受信したリクエストからトラックバックを抽出するインターフェース。
 * 
 * @since 1.2.3
 * @author Tomohiro Otsuka
 * @version $Id: TrackBackExtractor.java 202 2005-12-08 14:32:51Z otsuka $
 */
public interface TrackBackExtractor {

	/**
	 * 指定されたリクエストをパースし、TrackBackPingインスタンスを生成して返します。
	 * 
	 * @param request
	 * @return リクエストに含まれるパラメータ値から生成されたトラックバックPing。
	 * @throws UnsupportedEncodingException トラックバックPingの文字コード変換に失敗した場合
	 */
	TrackBackPing getTrackBackPingFromRequest(HttpServletRequest request) throws UnsupportedEncodingException;

}