package com.ozacc.blog.trackback;

/**
 * AsyncTrackBackClientで非同期にトラックバックPingを送信した結果を処理するコールバックハンドラ。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: TrackBackCallbackHandler.java 180 2005-07-22 09:26:25Z otsuka $
 */
public interface TrackBackCallbackHandler {

	/**
	 * トラックバックPingの送信に成功した時に呼ばれます。
	 * 
	 * @param trackBackPingUrl トラックバックURL
	 * @param ping 送信したトラックバックPing
	 */
	void handleResult(String trackBackPingUrl, TrackBackPing ping);

	/**
	 * トラックバックPingの送信でエラーが発生した時に呼ばれます。
	 * 
	 * @param trackBackPingUrl トラックバックURL
	 * @param ping 送信したトラックバックPing
	 * @param ex スローされた例外
	 */
	void handleError(String trackBackPingUrl, TrackBackPing ping, TrackBackException ex);

}