package com.ozacc.blog.feed.impl;

import java.io.Serializable;
import java.net.URL;
import java.util.Date;

import com.ozacc.blog.feed.Item;

/**
 * Item インターフェースの実装クラス。
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: ItemImpl.java 197 2005-08-10 01:43:23Z otsuka $
 */
public class ItemImpl implements Item, Serializable {

	private String description;

	private URL link;

	private String title;

	private String language;

	private Date date;

	private String creator;

	private String subject;

	private String encoded;

	/**
	 * コンストラクタ。
	 */
	public ItemImpl() {
		super();
	}

	/**
	 * @see com.ozacc.blog.feed.Item#getDescription()
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @see com.ozacc.blog.feed.Item#setDescription(java.lang.String)
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @see com.ozacc.blog.feed.Item#getLink()
	 */
	public URL getLink() {
		return link;
	}

	/**
	 * @see com.ozacc.blog.feed.Item#setLink(java.net.URL)
	 */
	public void setLink(URL url) {
		this.link = url;
	}

	/**
	 * @see com.ozacc.blog.feed.Item#getTitle()
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * @see com.ozacc.blog.feed.Item#setTitle(java.lang.String)
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getLanguage()
	 */
	public String getLanguage() {
		return language;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setLanguage(java.lang.String)
	 */
	public void setLanguage(String language) {
		this.language = language;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getDate()
	 */
	public Date getDate() {
		return date;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setDate(java.util.Date)
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getCreator()
	 */
	public String getCreator() {
		return creator;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setCreator(java.lang.String)
	 */
	public void setCreator(String creator) {
		this.creator = creator;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getSubject()
	 */
	public String getSubject() {
		return subject;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setSubject(java.lang.String)
	 */
	public void setSubject(String subject) {
		this.subject = subject;
	}

	/**
	 * @see com.ozacc.blog.feed.ContentMetadata#getEncoded()
	 */
	public String getEncoded() {
		return encoded;
	}

	/**
	 * @see com.ozacc.blog.feed.ContentMetadata#setEncoded(java.lang.String)
	 */
	public void setEncoded(String encoded) {
		this.encoded = encoded;
	}

}