package com.ozacc.blog.feed.impl;

import java.net.URL;
import java.util.Date;

import com.ozacc.blog.feed.Channel;
import com.ozacc.blog.feed.Item;
import com.ozacc.blog.util.XmlUtils;

/**
 * Channelインスタンスをラップし、getterで出力する際に文字列にXMLエスケープを施します。
 * Channelに含まれるItemインスタンスにはItemWrapperが適用されます。
 * 
 * @see ItemWrapper
 * @since 1.2.7
 * @author Tomohiro Otsuka
 * @version $Id: ChannelWrapper.java 197 2005-08-10 01:43:23Z otsuka $
 */
public class ChannelWrapper implements Channel {

	private Channel c;

	public ChannelWrapper(Channel channel) {
		super();
		this.c = channel;
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#getItems()
	 */
	public Item[] getItems() {
		Item[] items = c.getItems();
		ItemWrapper[] result = new ItemWrapper[items.length];
		for (int i = 0; i < items.length; i++) {
			result[i] = new ItemWrapper(items[i]);
		}
		return result;
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#addItem(com.ozacc.blog.feed.Item)
	 */
	public void addItem(Item item) {
		c.addItem(item);
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#getTitle()
	 */
	public String getTitle() {
		return XmlUtils.escapeXml(c.getTitle());
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#setTitle(java.lang.String)
	 */
	public void setTitle(String title) {
		c.setTitle(title);
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#getLink()
	 */
	public URL getLink() {
		return c.getLink();
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#setLink(java.net.URL)
	 */
	public void setLink(URL url) {
		c.setLink(url);
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#getDescription()
	 */
	public String getDescription() {
		return XmlUtils.escapeXml(c.getDescription());
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#setDescription(java.lang.String)
	 */
	public void setDescription(String description) {
		c.setDescription(description);
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#newItem()
	 */
	public Item newItem() {
		return c.newItem();
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getLanguage()
	 */
	public String getLanguage() {
		return XmlUtils.escapeXml(c.getLanguage());
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setLanguage(java.lang.String)
	 */
	public void setLanguage(String language) {
		c.setLanguage(language);
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getDate()
	 */
	public Date getDate() {
		return c.getDate();
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setDate(java.util.Date)
	 */
	public void setDate(Date date) {
		c.setDate(date);
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getCreator()
	 */
	public String getCreator() {
		return XmlUtils.escapeXml(c.getCreator());
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setCreator(java.lang.String)
	 */
	public void setCreator(String creator) {
		c.setCreator(creator);
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getSubject()
	 */
	public String getSubject() {
		return XmlUtils.escapeXml(c.getSubject());
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setSubject(java.lang.String)
	 */
	public void setSubject(String subject) {
		c.setSubject(subject);
	}

}