package com.ozacc.blog.feed.impl;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ozacc.blog.feed.Channel;
import com.ozacc.blog.feed.Item;

/**
 * Informaに依存しないozacc-blogの独自実装を作ろうと奮闘中。
 * まだこのクラスに出番はありません。
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: ChannelImpl.java 197 2005-08-10 01:43:23Z otsuka $
 */
public class ChannelImpl implements Channel, Serializable {

	private String title;

	private String language;

	private String creator;

	private String subject;

	private Date date;

	private String description;

	private URL link;

	private List items;

	/**
	 * コンストラクタ。
	 */
	public ChannelImpl() {
		super();
		items = new ArrayList();
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#getItems()
	 */
	public Item[] getItems() {
		return (Item[])items.toArray(new Item[items.size()]);
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#addItem(com.ozacc.blog.feed.Item)
	 */
	public void addItem(Item item) {
		items.add(item);
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#getTitle()
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#setTitle(java.lang.String)
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#getLink()
	 */
	public URL getLink() {
		return link;
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#setLink(java.net.URL)
	 */
	public void setLink(URL url) {
		this.link = url;
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#getDescription()
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#setDescription(java.lang.String)
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @see com.ozacc.blog.feed.Channel#newItem()
	 */
	public Item newItem() {
		return new ItemImpl();
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getLanguage()
	 */
	public String getLanguage() {
		return language;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setLanguage(java.lang.String)
	 */
	public void setLanguage(String language) {
		this.language = language;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getDate()
	 */
	public Date getDate() {
		return date;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setDate(java.util.Date)
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getCreator()
	 */
	public String getCreator() {
		return creator;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setCreator(java.lang.String)
	 */
	public void setCreator(String creator) {
		this.creator = creator;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getSubject()
	 */
	public String getSubject() {
		return subject;
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setSubject(java.lang.String)
	 */
	public void setSubject(String subject) {
		this.subject = subject;
	}

}