package com.ozacc.blog.feed;

import java.io.File;
import java.io.IOException;

import org.jdom.Document;

/**
 * フィードの出力インターフェース。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: FeedGenerator.java 197 2005-08-10 01:43:23Z otsuka $
 */
public interface FeedGenerator {

	/**
	 * Channelを指定されたファイルに出力します。
	 * 
	 * @param channel 出力するChannel
	 * @param file 出力先ファイル
	 * @param rssVersion 出力されるRSSフォーマットのバージョン
	 * @throws IOException ファイルの書き出しに失敗した場合
	 */
	void write(Channel channel, File file, FeedFormat rssVersion) throws IOException;

	/**
	 * Channelを指定されたバージョンのRSS XMLの文字列に変換して返します。
	 * 
	 * @since 1.2.6
	 * 
	 * @param channel XML文字列として出力するChannel
	 * @param rssVersion 出力されるRSSフォーマットのバージョン
	 * @return RSS XMLの文字列
	 */
	String convertIntoString(Channel channel, FeedFormat rssVersion);

	/**
	 * ChannelをJDOM Documentに変換します。
	 * 
	 * @deprecated
	 * 
	 * @param channel 変換元のChannel
	 * @param rssVersion RSSフォーマットのバージョン
	 * @return JDOM Document
	 */
	Document convertIntoJDOMDocument(Channel channel, FeedFormat rssVersion);

}