package com.ozacc.mail.impl;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.VelocityMailBuilder;

/**
 * XMLեɤ߹ߡVelocityϢȤưŪ˥᡼ǡΥǡMail󥹥󥹤륯饹
 * 
 * @since 1.0.1
 * @author Tomohiro Otsuka
 * @version $Id: XMLVelocityMailBuilderImpl.java,v 1.10 2006/03/03 06:04:22 otsuka Exp $
 */
public class XMLVelocityMailBuilderImpl extends XMLMailBuilderImpl implements VelocityMailBuilder {

	private static Log log = LogFactory.getLog(XMLVelocityMailBuilderImpl.class);

	protected String charset = "UTF-8";

	static {
		Velocity.setProperty(Velocity.RUNTIME_LOG_LOGSYSTEM, new VelocityLogSystem());
		try {
			Velocity.init();
		} catch (Exception e) {
			throw new MailBuildException("Velocityν˼Ԥޤ", e);
		}
	}

	protected Map templateCache = new HashMap();

	private boolean cacheEnabled = false;

	protected boolean hasTemplateCache(String key) {
		if (cacheEnabled) {
			return templateCache.containsKey(key);
		}
		return false;
	}

	protected void putTemplateCache(String key, String templateXmlText) {
		if (cacheEnabled) {
			log.debug("ƥץ졼Ȥ򥭥å夷ޤ[key='" + key + "']");
			templateCache.put(key, templateXmlText);
		}
	}

	protected String getTemplateCache(String key) {
		if (hasTemplateCache(key)) {
			log.debug("ƥץ졼ȥå֤ޤ[key='" + key + "']");
			return (String)templateCache.get(key);
		}
		return null;
	}

	/**
	 * @see com.ozacc.mail.VelocityMailBuilder#clearCache()
	 */
	public synchronized void clearCache() {
		log.debug("ƥץ졼ȥå򥯥ꥢޤ");
		templateCache.clear();
	}

	/**
	 * @see com.ozacc.mail.VelocityMailBuilder#isCacheEnabled()
	 */
	public boolean isCacheEnabled() {
		return cacheEnabled;
	}

	/**
	 * @see com.ozacc.mail.VelocityMailBuilder#setCacheEnabled(boolean)
	 */
	public void setCacheEnabled(boolean cacheEnabled) {
		if (!cacheEnabled) {
			clearCache();
		}
		this.cacheEnabled = cacheEnabled;
	}

	/**
	 * @see com.ozacc.mail.VelocityMailBuilder#buildMail(java.lang.String, org.apache.velocity.VelocityContext)
	 */
	public Mail buildMail(String classPath, VelocityContext context) throws MailBuildException {
		String templateXmlText;
		if (!hasTemplateCache(classPath)) {
			Document doc;
			try {
				// VelocityޡXMLǤϥȤĤ
				doc = getDocumentFromClassPath(classPath, false);
			} catch (SAXException e) {
				throw new MailBuildException("XMLΥѡ˼Ԥޤ" + e.getMessage(), e);
			} catch (IOException e) {
				throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
			}
			templateXmlText = convertDocumentIntoString(doc);
			putTemplateCache(classPath, templateXmlText);
		} else {
			templateXmlText = getTemplateCache(classPath);
		}

		try {
			return build(templateXmlText, context);
		} catch (Exception e) {
			throw new MailBuildException("᡼˼Ԥޤ", e);
		}
	}

	/**
	 * @see com.ozacc.mail.VelocityMailBuilder#buildMail(java.io.File, org.apache.velocity.VelocityContext)
	 */
	public Mail buildMail(File file, VelocityContext context) throws MailBuildException {
		String templateXmlText;
		if (!hasTemplateCache(file.getAbsolutePath())) {
			Document doc;
			try {
				// VelocityޡXMLǤϥȤĤ
				doc = getDocumentFromFile(file, false);
			} catch (SAXException e) {
				throw new MailBuildException("XMLΥѡ˼Ԥޤ" + e.getMessage(), e);
			} catch (IOException e) {
				throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
			}
			templateXmlText = convertDocumentIntoString(doc);
			putTemplateCache(file.getAbsolutePath(), templateXmlText);
		} else {
			templateXmlText = getTemplateCache(file.getAbsolutePath());
		}

		try {
			return build(templateXmlText, context);
		} catch (Exception e) {
			throw new MailBuildException("᡼˼Ԥޤ", e);
		}
	}

	/**
	 * ᡼ǡVelocityContextȥޡ줿XMLMail󥹥󥹤ޤ
	 * 
	 * @param templateXmlText ᡼ǡΥƥץ졼
	 * @param context ƥץ졼Ȥ˥ޡƤǼVelocityContext
	 * @return VelocityContextƥץ졼Ȥ˥ޡ줿XML줿Mail󥹥
	 * @throws TransformerFactoryConfigurationError
	 * @throws Exception
	 * @throws ParseErrorException
	 * @throws MethodInvocationException
	 * @throws ResourceNotFoundException
	 * @throws IOException
	 */
	protected Mail build(String templateXmlText, VelocityContext context)
																			throws TransformerFactoryConfigurationError,
																			Exception,
																			ParseErrorException,
																			MethodInvocationException,
																			ResourceNotFoundException,
																			IOException {
		if (log.isDebugEnabled()) {
			log.debug("Source XML Mail Data\n" + templateXmlText);
		}

		StringWriter w = new StringWriter();
		Velocity.evaluate(context, w, "XML Mail Data", templateXmlText);
		StringReader reader = new StringReader(w.toString());

		DocumentBuilder db = createDocumentBuilder();
		InputSource source = new InputSource(reader);
		Document newDoc = db.parse(source);

		if (log.isDebugEnabled()) {
			String newXmlContent = convertDocumentIntoString(newDoc);
			log.debug("VelocityContext-merged XML Mail Data\n" + newXmlContent);
		}

		return buildMail(newDoc);
	}

	/**
	 * ꤵ줿DOM DocumentʸѴޤ
	 * 
	 * @param doc
	 * @return XMLɥȤʸ
	 * @throws TransformerFactoryConfigurationError 
	 */
	protected String convertDocumentIntoString(Document doc)
															throws TransformerFactoryConfigurationError {
		TransformerFactory tf = TransformerFactory.newInstance();
		Transformer t;
		try {
			t = tf.newTransformer();
		} catch (TransformerConfigurationException e) {
			throw new MailBuildException(e.getMessage(), e);
		}
		t.setOutputProperties(getOutputProperties());

		DOMSource source = new DOMSource(doc);
		StringWriter w = new StringWriter();
		StreamResult result = new StreamResult(w);
		try {
			t.transform(source, result);
		} catch (TransformerException e) {
			throw new MailBuildException(e.getMessage(), e);
		}

		return w.toString();
	}

	/**
	 * ϥץѥƥ
	 * @return ϥץѥƥꤷProperties󥹥
	 */
	protected Properties getOutputProperties() {
		Properties p = new Properties();
		p.put(OutputKeys.ENCODING, charset);
		p.put(OutputKeys.DOCTYPE_PUBLIC, Mail.DOCTYPE_PUBLIC);
		p.put(OutputKeys.DOCTYPE_SYSTEM, Mail.DOCTYPE_SYSTEM);
		return p;
	}

}