package com.ozacc.mail.impl;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;

import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailAuthenticationException;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MailException;
import com.ozacc.mail.MailSendException;
import com.ozacc.mail.NotConnectedException;
import com.ozacc.mail.SendMailPro;

/**
 * SendMailPro󥿡եμ饹
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: SendMailProImpl.java,v 1.5 2005/01/17 15:28:18 otsuka Exp $
 */
public class SendMailProImpl implements SendMailPro {

	/** smtp */
	public static final String DEFAULT_PROTOCOL = "smtp";

	/** -1 */
	public static final int DEFAULT_PORT = -1;

	/** localhost */
	public static final String DEFAULT_HOST = "localhost";

	/** ISO-2022-JP */
	public static final String JIS_CHARSET = "ISO-2022-JP";

	private static final String RETURN_PATH_KEY = "mail.smtp.from";

	private static Log log = LogFactory.getLog(SendMailProImpl.class);

	/** ³ॢ */
	private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;

	/** ɹॢ */
	private static final int DEFAULT_READ_TIMEOUT = 5000;

	private String protocol = DEFAULT_PROTOCOL;

	private String host = DEFAULT_HOST;

	private int port = DEFAULT_PORT;

	private String username;

	private String password;

	private String charset = JIS_CHARSET;

	private String returnPath;

	private Session session;

	private Transport transport;

	private boolean connected;

	private String messageId;

	private int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;

	private int readTimeout = DEFAULT_READ_TIMEOUT;

	/**
	 * 󥹥ȥ饯
	 */
	public SendMailProImpl() {}

	/**
	 * 󥹥ȥ饯ѤSMTPФꤷޤ
	 * 
	 * @param host SMTPФΥۥ̾ޤIPɥ쥹
	 */
	public SendMailProImpl(String host) {
		this();
		setHost(host);
	}

	/**
	 * @see com.ozacc.mail.SendMailPro#connect()
	 */
	public synchronized void connect() throws MailException {
		if (session == null) {
			initSession();
		}

		// ХReturn-Path
		putOnReturnPath(this.returnPath);

		try {
			// SMTPФ³
			log.debug("SMTP[" + host + "]³ޤ");

			transport = session.getTransport(protocol);
			transport.connect(host, port, username, password);
		} catch (AuthenticationFailedException ex) {
			log.error("SMTP[" + host + "]ؤ³ǧڤ˼Ԥޤ", ex);
			throw new MailAuthenticationException(ex);
		} catch (MessagingException ex) {
			log.error("SMTP[" + host + "]ؤ³˼Ԥޤ", ex);
			throw new MailSendException("SMTP[" + host + "]ؤ³˼Ԥޤ", ex);
		}

		log.debug("SMTP[" + host + "]³ޤ");

		connected = true;
	}

	/**
	 * SessionνԤޤ
	 * ॢͤꤷProperties򥻥åȤޤ
	 */
	private void initSession() {
		Properties prop = new Properties();
		// ॢȤ
		prop.put("mail.smtp.connectiontimeout", String.valueOf(connectionTimeout));
		prop.put("mail.smtp.timeout", String.valueOf(readTimeout));
		//	mail.smtp.authץѥƥ
		if (username != null && !"".equals(username) && password != null && !"".equals(password)) {
			prop.put("mail.smtp.auth", "true");
		}
		session = Session.getInstance(prop);
	}

	/**
	 * @see com.ozacc.mail.SendMailPro#disconnect()
	 */
	public synchronized void disconnect() throws MailException {
		if (connected) {
			try {
				log.debug("SMTP[" + host + "]Ȥ³Ǥޤ");

				// SMTPФȤ³
				transport.close();
				connected = false;

				log.debug("SMTP[" + host + "]Ȥ³Ǥޤ");
			} catch (MessagingException ex) {
				log.error("SMTP[" + host + "]Ȥ³Ǥ˼Ԥޤ", ex);
				throw new MailException("SMTP[" + host + "]Ȥ³Ǥ˼Ԥޤ");
			} finally {
				// ХReturn-Pathβ
				releaseReturnPath(false);
			}
		} else {
			log.warn("SMTP[" + host + "]Ȥ³ΩƤʤ֤ǡ³ǤꥯȤޤ");
		}
	}

	/**
	 * ReturnPath򥻥åȤޤ
	 * 
	 * @param returnPath
	 */
	private void putOnReturnPath(String returnPath) {
		if (returnPath != null) {
			session.getProperties().put(RETURN_PATH_KEY, returnPath);
			log.debug("Return-Path[" + returnPath + "]ꤷޤ");
		}
	}

	/**
	 * ReturnPath򥯥ꥢޤ
	 * <p>
	 * setGlobalReturnPathAgaintrue˻ꤵƤ硢öReturn-Path򥯥ꥢˡ
	 * ХReturn-Path(setReturnPath()᥽åɤǡΥ󥹥󥹤˥åȤ줿Return-Pathɥ쥹)ꤷޤ
	 * ХReturn-PathåȤƤʤReturn-Pathϥꥢ줿ޤޤˤʤޤ
	 * <p>
	 * ꥢ줿֤send()᥽åɤ¹ԤȡFromͤReturn-Path˻Ѥޤ
	 * 
	 * @param setGlobalReturnPathAgain Return-Path򥯥ꥢ塢٥ХReturn-Path򥻥åȤ true
	 */
	private void releaseReturnPath(boolean setGlobalReturnPathAgain) {
		session.getProperties().remove(RETURN_PATH_KEY);
		log.debug("Return-Path򥯥ꥢޤ");

		if (setGlobalReturnPathAgain && this.returnPath != null) {
			putOnReturnPath(this.returnPath);
		}
	}

	/**
	 * @see com.ozacc.mail.SendMailPro#send(javax.mail.internet.MimeMessage)
	 */
	public void send(MimeMessage mimeMessage) throws MailException {
		if (!connected) {
			log.error("SMTPФؤ³ΩƤޤ");
			throw new NotConnectedException("SMTPФؤ³ΩƤޤ");
		}

		try {
			// 򥻥å
			mimeMessage.setSentDate(new Date());
			mimeMessage.saveChanges();
			// 
			log.debug("᡼ޤ");
			transport.sendMessage(mimeMessage, mimeMessage.getAllRecipients());
			log.debug("᡼ޤ");
		} catch (MessagingException ex) {
			log.error("᡼˼Ԥޤ", ex);
			throw new MailSendException("᡼˼Ԥޤ", ex);
		}
	}

	/**
	 * @see com.ozacc.mail.SendMailPro#send(com.ozacc.mail.Mail)
	 */
	public void send(Mail mail) throws MailException {
		if (mail.getReturnPath() != null) {
			sendMailWithReturnPath(mail);
		} else {
			sendMail(mail);
		}
	}

	/**
	 * ꤵ줿MailMimeMessagesend(MimeMessage)᥽åɤϤޤ
	 * 
	 * @param mail
	 * @throws MailException
	 */
	private void sendMail(Mail mail) throws MailException {
		// MimeMessage
		MimeMessage message = createMimeMessage();
		MimeMessageBuilder builder = new MimeMessageBuilder(message, charset);
		try {
			builder.buildMimeMessage(mail);
		} catch (UnsupportedEncodingException e) {
			throw new MailBuildException("ݡȤƤʤʸɤꤵޤ", e);
		} catch (MessagingException e) {
			throw new MailBuildException("MimeMessage˼Ԥޤ", e);
		}
		// 
		send(message);
	}

	/**
	 * ꤵ줿Mail˥åȤ줿Return-Pathꤷơ᡼ޤ
	 * Ʊ᥽åɤǤ
	 * 
	 * @param mail
	 * @throws MailException
	 */
	private synchronized void sendMailWithReturnPath(Mail mail) throws MailException {
		putOnReturnPath(mail.getReturnPath().getAddress());

		sendMail(mail);

		releaseReturnPath(true);
	}

	/**
	 * MimeMessage֥Ȥޤ
	 * 
	 * @return MimeMessage֥
	 */
	public MimeMessage createMimeMessage() {
		if (messageId == null) {
			return new MimeMessage(session);
		}
		return new OMLMimeMessage(session, messageId);
	}

	/**
	 * @return Returns the session.
	 */
	protected Session getSession() {
		return session;
	}

	/**
	 * 󥳡ǥ󥰤˻Ѥʸɤ֤ޤ
	 * 
	 * @return 󥳡ǥ󥰤˻Ѥʸ
	 */
	public String getCharset() {
		return charset;
	}

	/**
	 * ᡼η̾ʸΥ󥳡ǥ󥰤˻Ѥʸɤꤷޤ
	 * ǥեȤ ISO-2022-JP Ǥ
	 * <p>
	 * ܸĶѤ̾ѹɬפϤޤ
	 * 
	 * @param charset 󥳡ǥ󥰤˻Ѥʸ
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * @return Returns the host.
	 */
	public String getHost() {
		return host;
	}

	/**
	 * SMTPФΥۥ̾ޤIPɥ쥹򥻥åȤޤ
	 * ǥեȤ localhost Ǥ
	 * 
	 * @param host SMTPФΥۥ̾ޤIPɥ쥹
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return SMTPǧڥѥ
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * SMTPФ³ǧڤɬפʾ˥ѥɤ򥻥åȤޤ
	 * 
	 * @param password SMTPǧڥѥ
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @return SMTPФΥݡֹ
	 */
	public int getPort() {
		return port;
	}

	/**
	 * SMTPФΥݡֹ򥻥åȤޤ
	 * 
	 * @param port SMTPФΥݡֹ
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * @return Returns the protocol.
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * @param protocol The protocol to set.
	 */
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * @return Return-Pathɥ쥹
	 */
	public String getReturnPath() {
		return returnPath;
	}

	/**
	 * Return-Pathɥ쥹򥻥åȤޤ
	 * <p>
	 * Mail󥹥󥹤˻ꤵ줿Fromɥ쥹ʳΥɥ쥹Return-PathȤ˻Ѥޤ
	 * ǥåȤ줿Return-PathꡢMail󥹥󥹤˥åȤ줿Return-Pathͥ褵ޤ
	 * 
	 * @param returnPath Return-Pathɥ쥹
	 */
	public void setReturnPath(String returnPath) {
		this.returnPath = returnPath;
	}

	/**
	 * @return SMTPǧڥ桼̾
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * SMTPФ³ǧڤɬפʾ˥桼̾򥻥åȤޤ
	 * 
	 * @param username SMTPǧڥ桼̾
	 */
	public void setUsername(String username) {
		this.username = username;
	}

	/**
	 * MimeMessageդMessage-IdإåΥɥᥤʬꤷޤ<br>
	 * ꤵʤ(nullʸξ)ϡJavaMailMessage-Idإåޤ
	 * JavaMailJavaMail.¹ԥ桼̾@ۥ̾פMessage-Id򤱤ˡΥ᥽åɤѤޤ
	 * <p>
	 * messageIdץѥƥåȤƤ硢MailMimeMessageMessage-Idˤ
	 * <code>ॹ + 16ο + ǥåȤ줿</code>
	 * Ѥޤ
	 * <p>
	 * Message-Id㡣 (ºݤοʬ᡼Ѥޤ)<ul>
	 * <li>messageId'example.com'ꤷ硦1095714924963.5619528074501343@example.com</li>
	 * <li>messageId'@example.com'ꤷ硦1095714924963.5619528074501343@example.com (Ʊ)</li>
	 * <li>messageId'OML@example.com'ꤷ硦1095714924963.5619528074501343.OML@example.com</li>
	 * <li>messageId'.OML@example.com'ꤷ硦1095714924963.5619528074501343.OML@example.com (Ʊ)</li>
	 * </ul>
	 * <p>
	 * <strong>:</strong> Message-Id<code>send(Mail)</code><code>send(Mail[])</code>᥽åɤƤӤ줿ˤΤͭǤMimeMessageľˤŬѤޤ
	 * 
	 * @param messageId ᡼դMessage-IdإåΥɥᥤʬ
	 * @throws IllegalArgumentException @ʣޤʸꤷ
	 */
	public void setMessageId(String messageId) {
		if (messageId == null || messageId.length() < 1) {
			return;
		}

		String[] parts = messageId.split("@");
		if (parts.length > 2) {
			throw new IllegalArgumentException("messageIdץѥƥ'@'ʣޤळȤϤǤޤ[" + messageId
					+ "]");
		}

		this.messageId = messageId;
	}

	/**
	 * SMTPФȤ³ॢȤ򥻥åȤޤ
	 * ñ̤ϥߥáǥեȤ5,000ߥ(5)Ǥ
	 * <p>
	 * -1ꤹ̵ˤʤޤᤷޤ
	 * 
	 * @since 1.1.4
	 * @param connectionTimeout SMTPФȤ³ॢ
	 */
	public void setConnectionTimeout(int connectionTimeout) {
		this.connectionTimeout = connectionTimeout;
	}

	/**
	 * SMTPФؤΥॢȤ򥻥åȤޤ
	 * ñ̤ϥߥáǥեȤ5,000ߥ(5)Ǥ
	 * <p>
	 * -1ꤹ̵ˤʤޤᤷޤ
	 * 
	 * @since 1.1.4
	 * @param readTimeout SMTPФؤΥॢ
	 */
	public void setReadTimeout(int readTimeout) {
		this.readTimeout = readTimeout;
	}
}