/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailAuthenticationException;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MailException;
import com.ozacc.mail.MailSendException;
import com.ozacc.mail.SendMail;
import com.ozacc.mail.impl.MimeMessageBuilder;
import com.ozacc.mail.impl.OMLMimeMessage;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendMailImpl
implements SendMail {
    private static Log log = LogFactory.getLog(SendMailImpl.class);
    public static final String DEFAULT_PROTOCOL = "smtp";
    public static final int DEFAULT_PORT = -1;
    public static final String DEFAULT_HOST = "localhost";
    public static final String JIS_CHARSET = "ISO-2022-JP";
    private static final String RETURN_PATH_KEY = "mail.smtp.from";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private static final int DEFAULT_READ_TIMEOUT = 5000;
    private String protocol = "smtp";
    private String host = "localhost";
    private int port = -1;
    private String username;
    private String password;
    private String charset = "ISO-2022-JP";
    private String returnPath;
    private String messageId;
    private int connectionTimeout = 5000;
    private int readTimeout = 5000;
    static /* synthetic */ Class class$0;

    public SendMailImpl() {
    }

    public SendMailImpl(String host) {
        this();
        this.setHost(host);
    }

    public void send(Mail mail) throws MailException {
        this.send(new Mail[]{mail});
    }

    public void send(Mail[] mails) throws MailException {
        MimeMessageWrapper[] mmws = new MimeMessageWrapper[mails.length];
        Session session = Session.getInstance((Properties)new Properties());
        int i = 0;
        while (i < mails.length) {
            Mail mail = mails[i];
            MimeMessage message = this.createMimeMessage(session);
            MimeMessageBuilder builder = new MimeMessageBuilder(message);
            try {
                builder.buildMimeMessage(mail);
            }
            catch (UnsupportedEncodingException e) {
                throw new MailBuildException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002", e);
            }
            catch (MessagingException e) {
                throw new MailBuildException("MimeMessage\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
            String returnPath = mail.getReturnPath() != null ? mail.getReturnPath().getAddress() : this.returnPath;
            mmws[i] = new MimeMessageWrapper(message, returnPath);
            ++i;
        }
        this.processSend(mmws);
    }

    public void send(MimeMessage message) throws MailException {
        this.send(new MimeMessage[]{message});
    }

    public void send(MimeMessage[] messages) throws MailException {
        MimeMessageWrapper[] mmws = new MimeMessageWrapper[messages.length];
        int i = 0;
        while (i < messages.length) {
            mmws[i] = new MimeMessageWrapper(messages[i], this.returnPath);
            ++i;
        }
        this.processSend(mmws);
    }

    private void processSend(MimeMessageWrapper[] mmws) throws MailException {
        Properties prop = new Properties();
        prop.put("mail.smtp.connectiontimeout", String.valueOf(this.connectionTimeout));
        prop.put("mail.smtp.timeout", String.valueOf(this.readTimeout));
        Session session = Session.getInstance((Properties)prop);
        Transport transport = null;
        try {
            try {
                log.debug((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u306b\u63a5\u7d9a\u3057\u307e\u3059\u3002"));
                transport = session.getTransport(this.protocol);
                transport.connect(this.host, this.port, this.username, this.password);
                log.debug((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f\u3002"));
                int i = 0;
                while (i < mmws.length) {
                    MimeMessage mimeMessage = mmws[i].getMimeMessage();
                    String returnPath = mmws[i].getReturnPath();
                    if (returnPath != null) {
                        session.getProperties().put(RETURN_PATH_KEY, returnPath);
                        log.debug((Object)("Return-Path[" + returnPath + "]\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002"));
                    }
                    mimeMessage.setSentDate(new Date());
                    mimeMessage.saveChanges();
                    log.debug((Object)"\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3057\u307e\u3059\u3002");
                    transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
                    log.debug((Object)"\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3057\u307e\u3057\u305f\u3002");
                    if (returnPath != null) {
                        session.getProperties().remove(RETURN_PATH_KEY);
                        log.debug((Object)"Return-Path\u8a2d\u5b9a\u3092\u30af\u30ea\u30a2\u3057\u307e\u3057\u305f\u3002");
                    }
                    ++i;
                }
            }
            catch (AuthenticationFailedException ex) {
                log.error((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3078\u306e\u63a5\u7d9a\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"), (Throwable)ex);
                throw new MailAuthenticationException(ex);
            }
            catch (MessagingException ex) {
                log.error((Object)"\u30e1\u30fc\u30eb\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
                throw new MailSendException("\u30e1\u30fc\u30eb\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            }
        }
        finally {
            if (transport != null && transport.isConnected()) {
                log.debug((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u3092\u5207\u65ad\u3057\u307e\u3059\u3002"));
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    log.error((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u5207\u65ad\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"), (Throwable)e);
                    throw new MailException("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u5207\u65ad\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                }
                log.debug((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u3092\u5207\u65ad\u3057\u307e\u3057\u305f\u3002"));
            }
        }
    }

    private MimeMessage createMimeMessage(Session session) {
        if (this.messageId == null) {
            return new MimeMessage(session);
        }
        return new OMLMimeMessage(session, this.messageId);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getReturnPath() {
        return this.returnPath;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setMessageId(String messageId) {
        if (messageId == null || messageId.length() < 1) {
            return;
        }
        String[] parts = messageId.split("@");
        if (parts.length > 2) {
            throw new IllegalArgumentException("messageId\u30d7\u30ed\u30d1\u30c6\u30a3\u306b'@'\u3092\u8907\u6570\u542b\u3080\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002[" + messageId + "]");
        }
        this.messageId = messageId;
    }

    private static class MimeMessageWrapper {
        private MimeMessage mimeMessage;
        private String returnPath;

        public MimeMessageWrapper(MimeMessage mimeMessage, String returnPath) {
            this.mimeMessage = mimeMessage;
            this.returnPath = returnPath;
        }

        public MimeMessage getMimeMessage() {
            return this.mimeMessage;
        }

        public String getReturnPath() {
            return this.returnPath;
        }
    }
}

